/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.javafx.ui.components;

import com.itd.efiling.offline.common.util.CommonUtil;
import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import com.itd.efiling.offline.javafx.ui.components.FieldStatusChangeListener;
import com.itd.efiling.offline.javafx.ui.components.ValidationAware;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.control.TextArea;

public class ValTextArea
extends TextArea
implements ValidationAware {
    private final StringProperty target = new SimpleStringProperty();
    private final IntegerProperty maxLength = new SimpleIntegerProperty(250);

    public ValTextArea() {
        FieldStatusChangeListener fieldChangeListener = new FieldStatusChangeListener(this, (Node)this);
        this.focusedProperty().addListener((ChangeListener)fieldChangeListener);
        this.disableProperty().addListener((ChangeListener)fieldChangeListener);
    }

    @Override
    public String getTarget() {
        return this.target.getValue();
    }

    @Override
    public void setTarget(String target) {
        this.target.setValue(target);
        this.addFieldForValidation(target);
    }

    @Override
    public void addFieldForValidation(String target) {
        ValidationUtil.addFieldForValidation(target, this);
    }

    public StringProperty targetProperty() {
        return this.target;
    }

    @Override
    public int getMaxLength() {
        return this.maxLength.getValue();
    }

    public void setMaxLength(int maxAllowedLength) {
        this.maxLength.setValue((Number)maxAllowedLength);
    }

    public IntegerProperty maxLengthProperty() {
        return this.maxLength;
    }

    public void replaceText(int start, int end, String text) {
        if (start == end && !ValidationUtil.isStringEmpty(text) && !ValidationUtil.isStringEmpty(this.getText()) && this.getText().length() >= this.getMaxLength()) {
            return;
        }
        super.replaceText(start, end, text);
    }

    public void replaceSelection(String text) {
        text = CommonUtil.getPrintableChar(text);
        if (!ValidationUtil.isStringEmpty(this.getText()) && !ValidationUtil.isStringEmpty(text)) {
            int selLen = this.getSelectedText().length();
            int txtLen = text.length();
            int totalLen = this.getText().length() + txtLen - selLen;
            int diff = this.getMaxLength() - totalLen;
            if (diff < 0 && totalLen > this.getMaxLength()) {
                text = text.substring(0, txtLen + diff);
            }
        }
        super.replaceSelection(text);
    }

    @Override
    public void setData(Object src) {
        this.setText((String)src);
    }

    @Override
    public Object getData() {
        return this.getText();
    }
}

