/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.javafx.ui.components;

import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.player.ctrl.Form;
import com.itd.efiling.offline.common.util.DataTransporter;
import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import com.itd.efiling.offline.javafx.ui.components.ValTableView;
import com.itd.efiling.offline.javafx.ui.components.ValidationAware;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;

public class ValRowEditorPane<S>
extends TitledPane {
    public static final int ADD_OPERATION = 1;
    public static final int EDIT_OPERATION = 2;
    private int operation = 1;
    private ValTableView<S> rowFor = null;
    private final StringProperty target = new SimpleStringProperty();

    public ValRowEditorPane() {
        this.visibleProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                Form form = Form.getForm();
                if (form != null) {
                    if (t1.booleanValue()) {
                        ValRowEditorPane.this.getParent().layout();
                        form.getTabPane().setMouseTransparent(false);
                        ObservableList tabs = form.getTabPane().getTabs();
                        for (Tab tab : tabs) {
                            if (((Tab)form.getTabPane().getSelectionModel().getSelectedItem()).equals(tab)) continue;
                            tab.setDisable(true);
                        }
                        ValRowEditorPane.this.updateUI();
                    } else {
                        form.getTabPane().setMouseTransparent(false);
                        ObservableList tabs = form.getTabPane().getTabs();
                        for (Tab tab : tabs) {
                            tab.setDisable(false);
                        }
                    }
                }
            }
        });
    }

    public void updateUI() {
        AnchorPane root = (AnchorPane)this.getContent();
        GridPane form = (GridPane)root.getChildren().get(0);
        ObservableList nodes = form.getChildren();
        for (Node n : nodes) {
            String target;
            if (!(n instanceof ValidationAware) || ValidationUtil.isStringEmpty(target = ((ValidationAware)n).getTarget())) continue;
            DataTransporter.transferDataToUI((Object)Form.getForm(), target, n);
        }
    }

    public String getTarget() {
        return this.target.getValue();
    }

    public void setTarget(String target) {
        this.target.setValue(target);
    }

    public StringProperty targetProperty() {
        return this.target;
    }

    public ValTableView<S> getRowFor() {
        return this.rowFor;
    }

    public void setRowFor(ValTableView<S> rowFor) {
        this.rowFor = rowFor;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public ObservableList<Node> getFields() {
        AnchorPane anchorPane = (AnchorPane)this.getContent();
        GridPane gridPane = (GridPane)anchorPane.getChildren().get(0);
        ObservableList nodes = gridPane.getChildren();
        return nodes;
    }

    public boolean validateBeforeSave() {
        LoggerManager.LOG.info(" Before validateBeforeSave ");
        return ValidationUtil.validateBeforeSave(this.getFields());
    }

    public void callOnChangeUtilOnSave() {
        LoggerManager.LOG.info(" Before validateBeforeSave ");
        ValidationUtil.callOnChangeUtilOnSave(this.getFields());
    }
}

