/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.javafx.ui.components;

import com.itd.efiling.offline.common.util.CommonUtil;
import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import com.itd.efiling.offline.javafx.ui.components.FieldStatusChangeListener;
import com.itd.efiling.offline.javafx.ui.components.ValidationAware;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.control.PasswordField;

public class ValPasswordField
extends PasswordField
implements ValidationAware {
    private final StringProperty target = new SimpleStringProperty();
    private final IntegerProperty maxLength = new SimpleIntegerProperty(1000);
    private final StringProperty allowedChars = new SimpleStringProperty();
    private final BooleanProperty autoCaps = new SimpleBooleanProperty(false);

    public ValPasswordField() {
        FieldStatusChangeListener fieldChangeListener = new FieldStatusChangeListener(this, (Node)this);
        this.focusedProperty().addListener((ChangeListener)fieldChangeListener);
        this.disableProperty().addListener((ChangeListener)fieldChangeListener);
    }

    @Override
    public Object getData() {
        return this.getText();
    }

    @Override
    public String getTarget() {
        return this.target.getValue();
    }

    @Override
    public void setTarget(String target) {
        this.target.setValue(target);
        this.addFieldForValidation(target);
    }

    @Override
    public void addFieldForValidation(String target) {
        ValidationUtil.addFieldForValidation(target, this);
    }

    public StringProperty targetProperty() {
        return this.target;
    }

    @Override
    public int getMaxLength() {
        return this.maxLength.getValue();
    }

    public void setMaxLength(int maxAllowedLength) {
        this.maxLength.setValue((Number)maxAllowedLength);
    }

    public IntegerProperty maxLengthProperty() {
        return this.maxLength;
    }

    public String getAllowedChars() {
        return this.allowedChars.getValue();
    }

    public void setAllowedChars(String allowedChars) {
        this.allowedChars.setValue(allowedChars);
    }

    public StringProperty allowedCharsProperty() {
        return this.allowedChars;
    }

    public Boolean getAutoCaps() {
        return this.autoCaps.getValue();
    }

    public void setAutoCaps(Boolean autoCaps) {
        this.autoCaps.setValue(autoCaps);
    }

    public BooleanProperty autoCapsProperty() {
        return this.autoCaps;
    }

    @Override
    public void setData(Object src) {
        if (src != null) {
            this.setText(src.toString());
        } else {
            this.setText(null);
        }
    }

    public void replaceText(int start, int end, String text) {
        if (start == end && !ValidationUtil.isStringEmpty(text) && !ValidationUtil.isStringEmpty(this.getText()) && this.getText().length() >= this.getMaxLength()) {
            return;
        }
        if (this.autoCaps.getValue().booleanValue()) {
            text = text.toUpperCase();
        }
        if (this.matchTest(text)) {
            super.replaceText(start, end, text);
        }
    }

    public void replaceSelection(String text) {
        text = CommonUtil.getPrintableChar(text);
        if (!ValidationUtil.isStringEmpty(this.getText()) && !ValidationUtil.isStringEmpty(text)) {
            int selLen = this.getSelectedText().length();
            int txtLen = text.length();
            int totalLen = this.getText().length() + txtLen - selLen;
            int diff = this.getMaxLength() - totalLen;
            if (diff < 0 && totalLen > this.getMaxLength()) {
                text = text.substring(0, txtLen + diff);
            }
        }
        if (this.matchTest(text)) {
            super.replaceSelection(text);
        }
    }

    public boolean matchTest(String text) {
        return ValidationUtil.isStringEmpty((String)this.allowedChars.get()) || ValidationUtil.isStringEmpty(text) && text.length() == 0 || text.matches((String)this.allowedChars.get());
    }

    public void paste() {
        super.paste();
        String copyText = this.getText();
        if (copyText.length() > this.maxLength.getValue()) {
            this.setText(copyText.substring(0, this.maxLength.getValue()));
        }
        if (this.autoCaps.getValue().booleanValue()) {
            String text = this.getText().toUpperCase();
            this.setText(text);
        }
    }
}

