/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.javafx.ui.components;

import com.itd.efiling.offline.common.config.ComboBoxOptionsCacher;
import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import com.itd.efiling.offline.javafx.ui.components.FieldStatusChangeListener;
import com.itd.efiling.offline.javafx.ui.components.Option;
import com.itd.efiling.offline.javafx.ui.components.ValidationAware;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;

public class ValComboBox
extends ComboBox<Option<String, String>>
implements ValidationAware {
    private final StringProperty target = new SimpleStringProperty();

    public ValComboBox() {
        FieldStatusChangeListener fieldChangeListener = new FieldStatusChangeListener(this, (Node)this);
        this.focusedProperty().addListener((ChangeListener)fieldChangeListener);
        this.disableProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                if (t1.booleanValue()) {
                    ValComboBox.this.setValue(new Option<String, String>("-1", "Select"));
                }
            }
        });
    }

    @Override
    public String getTarget() {
        return this.target.getValue();
    }

    @Override
    public void setTarget(String target) {
        this.getItems().clear();
        this.getItems().addAll(ComboBoxOptionsCacher.getComboOptions(target));
        this.getSelectionModel().selectFirst();
        this.target.setValue(target);
        this.addFieldForValidation(target);
    }

    @Override
    public void addFieldForValidation(String target) {
        ValidationUtil.addFieldForValidation(target, this);
    }

    public StringProperty targetProperty() {
        return this.target;
    }

    @Override
    public void setData(Object src) {
        if (src == null) {
            this.getSelectionModel().selectFirst();
        } else {
            this.setValue(new Option<String, Object>(src.toString(), null));
        }
    }

    @Override
    public Object getData() {
        if ("-1".equals(((Option)this.getValue()).getKey())) {
            return null;
        }
        return ((Option)this.getValue()).getKey();
    }

    @Override
    public int getMaxLength() {
        return -1;
    }
}

