/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.javafx.ui.components;

import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.onchange.util.OnChangeCommonUtil;
import com.itd.efiling.offline.common.player.ctrl.Form;
import com.itd.efiling.offline.common.util.DataTransporter;
import com.itd.efiling.offline.common.util.JfxCommonUtil;
import com.itd.efiling.offline.common.validation.cachers.FieldValidtionCacher;
import com.itd.efiling.offline.common.validation.jaxb.beans.FieldValidatorRoot;
import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import com.itd.efiling.offline.common.validation.validators.ValidatorInteface;
import com.itd.efiling.offline.javafx.ui.components.ValidationAware;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;

public class FieldStatusChangeListener
implements ChangeListener<Boolean> {
    ValidationAware field;
    Node node;

    public FieldStatusChangeListener(ValidationAware field, Node node) {
        this.field = field;
        this.node = node;
    }

    public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
        BooleanProperty bov;
        if (ov instanceof BooleanProperty && "disable".equals((bov = (BooleanProperty)ov).getName())) {
            return;
        }
        if (t1.booleanValue()) {
            if (!this.node.isDisabled()) {
                JfxCommonUtil.setFieldStatus(this.field);
            }
        } else if (!t1.booleanValue() && !this.node.isDisabled()) {
            String target = this.field.getTarget();
            Object data = this.field.getData();
            JfxCommonUtil.clearFieldStatus();
            List<FieldValidatorRoot> fieldValidators = FieldValidtionCacher.getValidationImplementor(target);
            boolean hasErros = false;
            if (fieldValidators != null) {
                for (FieldValidatorRoot fvr : fieldValidators) {
                    ValidatorInteface validator = fvr.getValidator();
                    LoggerManager.LOG.fine("validator :  " + validator);
                    validator.onBlurValidateCtrl(data, target, this.node);
                    if (!validator.hasErrors()) continue;
                    hasErros = true;
                    break;
                }
            }
            if (hasErros || ValidationUtil.isObjectEmpty(data)) {
                DataTransporter.transferDataToBean((Object)Form.getForm(), target, null);
                OnChangeCommonUtil.executeOnChangeMethod(this.field);
            } else {
                DataTransporter.transferDataToBean((Object)Form.getForm(), target, data);
                OnChangeCommonUtil.executeOnChangeMethod(this.field);
            }
        }
    }
}

