/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.webservice.util;

import com.itd.efiling.offline.common.cachers.ConfigCacher;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.util.Base64Utils;
import com.itd.efiling.offline.common.util.EncryptManagementUtil;
import com.itd.efiling.offline.common.webservice.request.DitRequest;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;

public class WebserviceHelper {
    private static final String RESPONSE_NS = "http://incometaxindiaefiling.gov.in/ditsecws/response";
    private static final String URL = ConfigCacher.getConfigProperty("conn.check.url");

    public static String getElementTextContent(SOAPBody resBody, String elementName) {
        return resBody.getElementsByTagNameNS(RESPONSE_NS, elementName).item(0).getTextContent();
    }

    public static boolean isConnected() {
        boolean connected = false;
        try {
            URL url = new URL(URL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(ConfigCacher.getIntConfigProperty("conn.check.connect.timeout"));
            conn.setReadTimeout(ConfigCacher.getIntConfigProperty("conn.check.read.timeout"));
            conn.connect();
            conn.disconnect();
            connected = true;
        }
        catch (IOException ex) {
            LoggerManager.LOG.info("Failed to connect. {}" + ex);
        }
        return connected;
    }

    public static void addSecurityHeader(SOAPEnvelope envelope, DitRequest ditRequest) throws Exception {
        SOAPHeader header = envelope.getHeader();
        SOAPElement security = header.addChildElement("Security", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        String nonceString = UUID.randomUUID().toString();
        String userNameWithNonce = ditRequest.getFormInfo().getForm() + "^" + ditRequest.getFormInfo().getAsstYear() + "^" + nonceString;
        String passwordWithNonce = nonceString;
        SOAPElement usernameToken = security.addChildElement("UsernameToken", "wsse");
        SOAPElement username = usernameToken.addChildElement("Username", "wsse");
        username.addTextNode(EncryptManagementUtil.encrypt(userNameWithNonce));
        SOAPElement password = usernameToken.addChildElement("Password", "wsse");
        password.setAttribute("Type", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        password.addTextNode(EncryptManagementUtil.encrypt(passwordWithNonce));
        SOAPElement nonce = usernameToken.addChildElement("Nonce", "wsse");
        nonce.setAttribute("EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        nonce.addTextNode(Base64Utils.base64Encode(nonceString.getBytes()));
    }
}

