/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.webservice.util;

import com.itd.efiling.offline.common.cachers.ConfigCacher;
import com.itd.efiling.offline.common.dialog.MessageDialogCtrl;
import com.itd.efiling.offline.common.dialog.ctrl.SubmitFormSuccessController;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.player.ctrl.SubmitFormController;
import com.itd.efiling.offline.common.util.EncryptManagementUtil;
import com.itd.efiling.offline.common.webservice.request.FormSubmitRequest;
import com.itd.efiling.offline.common.webservice.request.SecureRequest;
import com.itd.efiling.offline.common.webservice.request.SubmitForm1;
import com.itd.efiling.offline.common.webservice.util.WebserviceHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Node;

public class SubmitFormUtil
extends Task<Void> {
    private static final String URL = ConfigCacher.getConfigProperty("sec.form.submit.webservice.url");
    private static SOAPConnectionFactory soapConnectionFactory;
    private static SOAPConnection soapConnection;
    private static JAXBContext submitFormContext;
    private static List<String> schemaError;
    public static File formFile;
    public static File pfxFile;
    public static SubmitFormController controller;

    private static void init() {
        try {
            if (soapConnectionFactory == null) {
                soapConnectionFactory = SOAPConnectionFactory.newInstance();
                soapConnection = soapConnectionFactory.createConnection();
            }
        }
        catch (Exception e) {
            LoggerManager.LOG.log(Level.SEVERE, "Error in init", e);
        }
    }

    protected Void call() throws Exception {
        try {
            LoggerManager.LOG.info("Thread call starts");
            long startTime = System.currentTimeMillis();
            this.sendRequest();
            long endTime = System.currentTimeMillis();
            LoggerManager.LOG.info("Thread call ends : time taken: " + (endTime - startTime));
        }
        catch (Exception e) {
            LoggerManager.LOG.log(Level.SEVERE, "Error in call function", e);
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                controller.getSubmit().setDisable(false);
            }
        });
        return null;
    }

    private void sendRequest() {
        LoggerManager.LOG.info("sendRequest starts");
        try {
            schemaError.clear();
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage request = messageFactory.createMessage();
            SOAPPart soapPart = request.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            SOAPBody soapBody = envelope.getBody();
            FormSubmitRequest submitFormRequest = new FormSubmitRequest(controller);
            SecureRequest secureRequest = EncryptManagementUtil.getSecuredRequest(submitFormRequest);
            SubmitForm1 submitForm1 = new SubmitForm1(secureRequest);
            if (submitFormContext == null) {
                submitFormContext = JAXBContext.newInstance((Class[])new Class[]{SubmitForm1.class});
            }
            Marshaller marshaller = submitFormContext.createMarshaller();
            marshaller.marshal((Object)submitForm1, (Node)soapBody);
            SOAPMessage response = soapConnection.call(request, (Object)URL);
            SOAPBody resBody = response.getSOAPPart().getEnvelope().getBody();
            SOAPFault soapFault = resBody.getFault();
            Node errorNode = resBody.getElementsByTagNameNS("http://incometaxindiaefiling.gov.in/ditsecws/response", "ErrorDesc").item(0);
            LoggerManager.LOG.info("Soap fault: , errorNode: " + soapFault + errorNode);
            if (soapFault != null) {
                String faultActor = soapFault.getFaultActor();
                final String faultString = soapFault.getFaultString();
                String faultCode = soapFault.getFaultCode();
                String error = "FaultActor: " + faultActor + "<br/>FaultCode: " + faultCode + "<br/>Fault: " + faultString;
                schemaError.add(error);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        controller.setErrorText(faultString);
                    }
                });
            } else if (errorNode != null) {
                final String error = errorNode.getTextContent();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        controller.setProgress(1.0);
                        controller.setErrorText(error);
                    }
                });
            } else {
                String transactionId = WebserviceHelper.getElementTextContent(resBody, "TransactionId");
                SubmitFormSuccessController.setTransactionId(transactionId);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        controller.cancel();
                        try {
                            SubmitFormSuccessController.generateSubmitFormSuccess();
                        }
                        catch (Exception e) {
                            LoggerManager.LOG.log(Level.SEVERE, "errori ", e);
                            MessageDialogCtrl.displayErrorDialog("Error", "Submit failed. Please try again later.");
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            LoggerManager.LOG.log(Level.SEVERE, "Error in sendRequest: ", e);
            schemaError.add(e.getMessage());
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    controller.setErrorText(e.getMessage());
                }
            });
        }
    }

    static {
        submitFormContext = null;
        schemaError = new ArrayList<String>();
        SubmitFormUtil.init();
    }
}

