/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.webservice.request;

import com.itd.efiling.offline.common.dialog.ctrl.SubmitFormDtl;
import com.itd.efiling.offline.common.player.ctrl.Form;
import com.itd.efiling.offline.common.player.ctrl.SubmitFormController;
import com.itd.efiling.offline.common.reference.holders.RefHolders;
import com.itd.efiling.offline.common.webservice.request.DitRequest;
import com.itd.efiling.offline.common.webservice.request.FormInfo;
import com.itd.efiling.offline.common.webservice.request.LoginInfo;
import java.text.SimpleDateFormat;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="FormSubmitRequest", namespace="http://incometaxindiaefiling.gov.in/ditsecws/request")
@XmlType(name="FormSubmitRequest", namespace="http://incometaxindiaefiling.gov.in/ditsecws/request", propOrder={"pan", "submitTo", "dataHandler", "signatureHandler"})
public class FormSubmitRequest
extends DitRequest {
    @XmlElement(name="Pan")
    private String pan;
    @XmlElement(name="SubmitTo")
    private String submitTo;
    @XmlElement(name="xmlFile")
    @XmlMimeType(value="application/octet-stream")
    private DataHandler dataHandler;
    @XmlElement(name="sigFile")
    @XmlMimeType(value="application/octet-stream")
    private DataHandler signatureHandler;

    @Override
    public DataHandler getDataHandler() {
        return this.dataHandler;
    }

    public void setDataHandler(DataHandler dataHandler) {
        this.dataHandler = dataHandler;
    }

    public String getPan() {
        return this.pan;
    }

    public void setPan(String pan) {
        this.pan = pan;
    }

    public String getSubmitTo() {
        return this.submitTo;
    }

    public void setSubmitTo(String submitTo) {
        this.submitTo = submitTo;
    }

    public DataHandler getSignatureHandler() {
        return this.signatureHandler;
    }

    public void setSignatureHandler(DataHandler signatureHandler) {
        this.signatureHandler = signatureHandler;
    }

    public FormSubmitRequest(SubmitFormController controller) {
        this.setLoginInfo(new LoginInfo());
        this.setFormInfo(new FormInfo());
        SubmitFormDtl formDtl = Form.getForm().getFormDtl();
        this.getLoginInfo().setUserId(formDtl.getUserID());
        this.getLoginInfo().setPassword(formDtl.getUserPassword());
        String dob = new SimpleDateFormat("dd/MM/yyyy").format(formDtl.getDob());
        this.getLoginInfo().setDob(dob);
        this.getFormInfo().setForm(RefHolders.form.getFormName());
        this.getFormInfo().setAsstYear(RefHolders.form.getAsstYear());
        this.setPan(RefHolders.form.getPan());
        if (controller.pcitType.isSelected()) {
            this.setSubmitTo("J");
        } else if (controller.cpcType.isSelected()) {
            this.setSubmitTo("C");
        }
        this.setUniqueRequestId(formDtl.getUserID() + "-" + UUID.randomUUID().toString());
        this.setDataHandler(new DataHandler((DataSource)new FileDataSource(RefHolders.outputFileSave)));
        this.setSignatureHandler(new DataHandler((DataSource)new FileDataSource(RefHolders.signatureFile)));
    }

    public FormSubmitRequest() {
    }
}

