/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.validation.validators;

import com.itd.efiling.offline.common.player.ctrl.Form;
import com.itd.efiling.offline.common.util.DataTransporter;
import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import com.itd.efiling.offline.common.validation.validators.ValidatorInteface;
import javafx.scene.Node;

public class PhoneNumberValidator
extends ValidatorInteface {
    private String stdCode;

    public String getStdCode() {
        return this.stdCode;
    }

    public void setStdCode(String stdCode) {
        this.stdCode = stdCode;
    }

    @Override
    public void validate(Object val, String name, Node node) {
        int phoneNumberLength;
        String landlineNumber = null;
        if (!ValidationUtil.isObjectEmpty(val)) {
            landlineNumber = val.toString();
        }
        Object stdCodeField = DataTransporter.getObjectFromPath((Object)Form.getForm(), this.stdCode, false);
        String stdCodeValue = null;
        if (stdCodeField != null) {
            stdCodeValue = stdCodeField.toString();
        }
        if ((phoneNumberLength = ValidationUtil.getLengthOfString(stdCodeValue) + ValidationUtil.getLengthOfString(landlineNumber)) != 0) {
            if (phoneNumberLength != 10 && phoneNumberLength != 0) {
                this.addFieldError(name, node);
            } else if (!ValidationUtil.isStringEmpty(landlineNumber) && landlineNumber.startsWith("0")) {
                this.addFieldError(name, node);
            }
        }
    }

    @Override
    public ValidatorInteface getImplementor() {
        return new PhoneNumberValidator();
    }
}

