/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.validation.validators;

import com.itd.efiling.offline.common.config.ComboBoxOptionsCacher;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import com.itd.efiling.offline.common.validation.validators.ValidatorInteface;
import javafx.scene.Node;

public class DropDownValidator
extends ValidatorInteface {
    private String dropDownKey;
    private String required;

    @Override
    public void validate(Object val, String name, Node node) {
        LoggerManager.LOG.fine("val" + val);
        if (!ValidationUtil.isObjectEmpty(val)) {
            if ("-1".equals(val)) {
                this.addFieldError(name, node);
            }
            if (!ComboBoxOptionsCacher.isDropDownValueValid(this.dropDownKey, val.toString())) {
                this.addFieldError(name, node);
            }
        } else if ("Y".equals(this.required)) {
            this.addFieldError(name, node);
        }
    }

    @Override
    public ValidatorInteface getImplementor() {
        return new DropDownValidator();
    }

    public String getDropDownKey() {
        return this.dropDownKey;
    }

    public void setDropDownKey(String dropDownKey) {
        this.dropDownKey = dropDownKey;
    }

    public String getRequired() {
        return this.required;
    }

    public void setRequired(String required) {
        this.required = required;
    }
}

