/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.validation.validators;

import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import com.itd.efiling.offline.common.validation.validators.ValidatorInteface;
import java.math.BigInteger;
import javafx.scene.Node;

public class BigIntegerValidator
extends ValidatorInteface {
    private static final BigInteger MIN_AMOUNT = BigInteger.ZERO;
    private static final BigInteger MAX_AMOUNT = BigInteger.valueOf(999999999999999999L);
    private BigInteger minValue;
    private BigInteger maxValue;
    private Boolean mandatory;

    @Override
    public void validate(Object obj, String name, Node node) {
        if (this.mandatory == null) {
            this.mandatory = false;
        }
        BigInteger fieldValue = null;
        if (!ValidationUtil.isObjectEmpty(obj)) {
            try {
                fieldValue = new BigInteger(obj.toString());
            }
            catch (Exception e) {
                String temp = this.getErrorCode();
                this.setErrorCode("error.number.invalid");
                this.addFieldError(name, node);
                this.setErrorCode(temp);
                return;
            }
        } else if (this.mandatory.booleanValue()) {
            this.setErrorCode("error.number.required");
            this.addFieldError(name, node);
        }
        BigInteger minValueTemp = MIN_AMOUNT;
        if (this.minValue != null) {
            minValueTemp = this.minValue;
        }
        BigInteger maxValueTemp = MAX_AMOUNT;
        if (this.maxValue != null) {
            maxValueTemp = this.maxValue;
        }
        if (fieldValue != null && (fieldValue.compareTo(minValueTemp) < 0 || fieldValue.compareTo(maxValueTemp) > 0)) {
            this.addFieldError(name, node);
        }
    }

    public BigInteger getMinValue() {
        return this.minValue;
    }

    public void setMinValue(BigInteger minValue) {
        this.minValue = minValue;
    }

    public BigInteger getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(BigInteger maxValue) {
        this.maxValue = maxValue;
    }

    public Boolean getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }

    @Override
    public ValidatorInteface getImplementor() {
        return new BigIntegerValidator();
    }
}

