/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.validation.validators;

import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import com.itd.efiling.offline.common.validation.validators.ValidatorInteface;
import java.math.BigDecimal;
import javafx.scene.Node;

public class BigDecimalValidator
extends ValidatorInteface {
    private static final BigDecimal MIN_AMOUNT = BigDecimal.ZERO;
    private static final BigDecimal MAX_AMOUNT = BigDecimal.valueOf(1.0E17);
    private BigDecimal minValue;
    private BigDecimal maxValue;
    private Boolean mandatory;

    @Override
    public void validate(Object obj, String name, Node node) {
        if (this.mandatory == null) {
            this.mandatory = false;
        }
        BigDecimal fieldValue = null;
        if (!ValidationUtil.isObjectEmpty(obj)) {
            try {
                fieldValue = new BigDecimal(obj.toString());
            }
            catch (Exception e) {
                String temp = this.getErrorCode();
                this.setErrorCode("error.number.invalid");
                this.addFieldError(name, node);
                this.setErrorCode(temp);
            }
        } else if (this.mandatory.booleanValue()) {
            this.setErrorCode("error.number.required");
            this.addFieldError(name, node);
        }
        if (this.mandatory == null) {
            this.mandatory = false;
        }
        BigDecimal minValueTemp = MIN_AMOUNT;
        if (this.minValue != null) {
            minValueTemp = this.minValue;
        }
        BigDecimal maxValueTemp = MAX_AMOUNT;
        if (this.maxValue != null) {
            maxValueTemp = this.maxValue;
        }
        if (fieldValue != null && (fieldValue.compareTo(minValueTemp) < 0 || fieldValue.compareTo(maxValueTemp) > 0)) {
            this.addFieldError(name, node);
        }
    }

    public BigDecimal getMinValue() {
        return this.minValue;
    }

    public void setMinValue(BigDecimal minValue) {
        this.minValue = minValue;
    }

    public BigDecimal getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(BigDecimal maxValue) {
        this.maxValue = maxValue;
    }

    public Boolean getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }

    @Override
    public ValidatorInteface getImplementor() {
        return new BigDecimalValidator();
    }
}

