/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.validation.cachers;

import com.itd.efiling.offline.common.config.Configs;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.validation.jaxb.beans.FieldRoot;
import com.itd.efiling.offline.common.validation.jaxb.beans.FieldValidatorRoot;
import com.itd.efiling.offline.common.validation.jaxb.beans.ValidatorRoot;
import com.itd.efiling.offline.common.validation.validators.ValidatorInteface;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

public class FieldValidtionCacher {
    private static final Map<String, List<FieldValidatorRoot>> FIELD_VALIDATORS_MAP = new LinkedHashMap<String, List<FieldValidatorRoot>>();

    private FieldValidtionCacher() {
    }

    private static void load() {
        try {
            String[] validationFiles;
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ValidatorRoot.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            for (String filePath : validationFiles = Configs.getConfigProperty("validation.file").split(";")) {
                InputStream is = FieldValidtionCacher.class.getResourceAsStream(filePath);
                ValidatorRoot validatorRoot = (ValidatorRoot)unmarshaller.unmarshal(is);
                for (FieldRoot root : validatorRoot.getFieldRoots()) {
                    String name = root.getName();
                    List<FieldValidatorRoot> list = root.getFieldValidatorRoot();
                    for (FieldValidatorRoot fvr : list) {
                        fvr.init();
                    }
                    FIELD_VALIDATORS_MAP.put(name, root.getFieldValidatorRoot());
                }
                is.close();
            }
            LoggerManager.LOG.info("FIELD_VALIDATORS_MAP " + FIELD_VALIDATORS_MAP.size());
        }
        catch (Exception e) {
            LoggerManager.LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public static List<FieldValidatorRoot> getValidationImplementor(String key) {
        return FIELD_VALIDATORS_MAP.get(key);
    }

    public static void invokeMethod(ValidatorInteface validator, String name, String value) {
        Class<?> classType = null;
        try {
            classType = validator.getClass();
            Field field = classType.getDeclaredField(name);
            String className = field.getType().getName();
            field.setAccessible(true);
            LoggerManager.LOG.fine("field : " + field + " : " + className);
            if (className.contains("BigDecimal")) {
                field.set(validator, new BigDecimal(value));
            } else if (className.contains("BigInteger")) {
                field.set(validator, new BigInteger(value));
            } else if (className.contains("Boolean")) {
                field.set(validator, Boolean.valueOf(value));
            } else if (className.contains("Integer") || className.contains("int")) {
                field.set(validator, Integer.parseInt(value));
            } else if (className.contains("Long") || className.contains("long")) {
                field.set(validator, Long.parseLong(value));
            } else if (className.contains("Double") || className.contains("double")) {
                field.set(validator, Double.parseDouble(value));
            } else if (className.contains("Float") || className.contains("float")) {
                field.set(validator, Float.valueOf(Float.parseFloat(value)));
            } else {
                field.set(validator, value);
            }
        }
        catch (Exception e) {
            LoggerManager.LOG.log(Level.SEVERE, "Error in invokeMethod() " + classType, e);
        }
    }

    static {
        FieldValidtionCacher.load();
    }
}

