/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.util;

import com.itd.efiling.offline.common.codec.Base64InputStream;
import com.itd.efiling.offline.common.codec.Base64OutputStream;
import com.itd.efiling.offline.common.config.Configs;
import com.itd.efiling.offline.common.dialog.MessageDialogCtrl;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.player.ctrl.Form;
import com.itd.efiling.offline.common.reference.holders.RefHolders;
import com.itd.efiling.offline.common.util.CustomValidationHandler;
import com.itd.efiling.offline.common.util.JfxCommonUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XmlUtil {
    public static final String SAVE_FILE_TYPE = Configs.getConfigProperty("final.save.file.type");
    public static final String SAVE_FILE_TYPE_DESC = Configs.getConfigProperty("final.save.file.type.desc");

    public static Document getDocument(File file) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        FilterInputStream is = null;
        if (file.getName().endsWith(".draft") && "Y".equals(Configs.getConfigProperty("encode.draft.flag"))) {
            is = new Base64InputStream(new FileInputStream(file));
        } else if (file.getName().endsWith(".zip") && ".zip".equals(Configs.getConfigProperty("final.save.file.type"))) {
            is = new ZipInputStream(new FileInputStream(file));
            ZipEntry ze = ((ZipInputStream)is).getNextEntry();
            LoggerManager.LOG.info("ze : " + ze);
        } else {
            is = new BufferedInputStream(new FileInputStream(file));
        }
        Document doc = dbf.newDocumentBuilder().parse(is);
        ((InputStream)is).close();
        return doc;
    }

    public static Object unmarshal(File xmlFile) throws Exception {
        String pckg = Configs.getConfigProperty("jaxb.context.package.name");
        return XmlUtil.unmarshal(xmlFile, pckg);
    }

    public static Object unmarshalForm15CB(File xmlFile, String pckg) throws Exception {
        Document document = XmlUtil.getDocument(xmlFile);
        String rootName = document.getDocumentElement().getLocalName();
        LoggerManager.LOG.info("rootName : " + rootName);
        try {
            if (rootName != null && rootName.toUpperCase().startsWith("FORM")) {
                JAXBContext jaxbContext = JAXBContext.newInstance((String)pckg);
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(XmlUtil.class.getResource(Configs.getConfigProperty("xsd15CB.file.path")));
                unmarshaller.setSchema(schema);
                Object root = unmarshaller.unmarshal((Node)document);
                JAXBElement obj = null;
                Object jaxbModel = null;
                if (root instanceof JAXBElement) {
                    obj = (JAXBElement)root;
                    jaxbModel = obj.getValue();
                } else {
                    jaxbModel = root;
                }
                return jaxbModel;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object unmarshal(File xmlFile, String pckg) throws Exception {
        Document document = XmlUtil.getDocument(xmlFile);
        String rootName = document.getDocumentElement().getLocalName();
        LoggerManager.LOG.info("rootName : " + rootName);
        if (rootName != null && rootName.toUpperCase().startsWith("FORM")) {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)pckg);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Object root = unmarshaller.unmarshal((Node)document);
            JAXBElement obj = null;
            Object jaxbModel = null;
            if (root instanceof JAXBElement) {
                obj = (JAXBElement)root;
                jaxbModel = obj.getValue();
            } else {
                jaxbModel = root;
            }
            return jaxbModel;
        }
        return null;
    }

    public static void generateXml(Form form, Boolean isSubmit) throws IOException, JAXBException, SAXException {
        File file = null;
        if (isSubmit.booleanValue()) {
            SecureRandom secureRandom = new SecureRandom();
            file = File.createTempFile("FORM" + secureRandom.nextInt(), SAVE_FILE_TYPE);
        } else {
            file = JfxCommonUtil.saveFileDialog(SAVE_FILE_TYPE, SAVE_FILE_TYPE_DESC);
        }
        if (file != null) {
            CustomValidationHandler validationHandler = new CustomValidationHandler();
            try {
                Object entity = form.getEntity();
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{entity.getClass()});
                Marshaller marshaller = jaxbContext.createMarshaller();
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(XmlUtil.class.getResource(Configs.getConfigProperty("xsd.file.path")));
                marshaller.setEventHandler((ValidationEventHandler)validationHandler);
                marshaller.setSchema(schema);
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                if (file.getName().endsWith(".zip")) {
                    ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                    ZipEntry ze = new ZipEntry(file.getName().replaceFirst(".zip", ".xml"));
                    zos.putNextEntry(ze);
                    marshaller.marshal(entity, (OutputStream)zos);
                    zos.closeEntry();
                    zos.close();
                } else {
                    marshaller.marshal(entity, file);
                }
                Form.getForm().setChanged(false);
                if (!isSubmit.booleanValue()) {
                    MessageDialogCtrl.displayInfoDialog("Success", "File saved successfully");
                }
                RefHolders.outputFileSave = file;
            }
            catch (Exception e) {
                LoggerManager.LOG.info("validationHandler " + validationHandler.getErrorMessage());
                LoggerManager.LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
                MessageDialogCtrl.displayErrorDialog(validationHandler.getErrorMessage());
            }
        }
    }

    public static void saveDraft(Form form) throws IOException, JAXBException {
        File xmlFile = JfxCommonUtil.saveFileDialog(".draft", "XML file");
        if (xmlFile != null) {
            if (!xmlFile.exists()) {
                xmlFile.createNewFile();
            }
            Object entity = form.getEntity();
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{entity.getClass()});
            Marshaller marshaler = jaxbContext.createMarshaller();
            marshaler.setProperty("jaxb.formatted.output", (Object)true);
            FilterOutputStream os = null;
            os = xmlFile.getName().endsWith(".draft") && "Y".equals(Configs.getConfigProperty("encode.draft.flag")) ? new Base64OutputStream(new BufferedOutputStream(new FileOutputStream(xmlFile))) : new BufferedOutputStream(new FileOutputStream(xmlFile));
            marshaler.marshal(entity, (OutputStream)os);
            ((OutputStream)os).close();
            Form.getForm().setChanged(false);
            MessageDialogCtrl.displayInfoDialog("Success", "Draft saved successfully");
        }
    }
}

