/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.util;

import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.util.Base64Utils;
import com.itd.efiling.offline.common.webservice.request.DitRequest;
import com.itd.efiling.offline.common.webservice.request.SecureRequest;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

public class EncryptManagementUtil {
    private static String AES_TRANSFORMATION = "AES/ECB/PKCS5Padding";
    private static String RSA_TRANSFORMATION = "RSA";
    private static String SECRET_KEY_ALGO = "AES";
    private static int SECRET_KEY_SIZE = 128;

    public static SecureRequest getSecuredRequest(DitRequest request) throws Exception {
        LoggerManager.LOG.info("Before getting secured request");
        SecureRequest secureRequest = new SecureRequest();
        KeyGenerator keyGenerator = KeyGenerator.getInstance(SECRET_KEY_ALGO);
        keyGenerator.init(SECRET_KEY_SIZE);
        SecretKey secretKey = keyGenerator.generateKey();
        Cipher cipher = Cipher.getInstance(AES_TRANSFORMATION, Security.getProvider("SunJCE"));
        cipher.init(1, secretKey);
        String requestDtlsXmlStr = EncryptManagementUtil.getRequestDtlsXmlStr(request, secretKey);
        byte[] encryptedByte = cipher.doFinal(requestDtlsXmlStr.getBytes());
        String requestEncrypted = Base64Utils.base64Encode(encryptedByte);
        secureRequest.setRequest(requestEncrypted);
        String encryptedKey = EncryptManagementUtil.wrap(secretKey);
        secureRequest.setEncryptedKey(encryptedKey);
        LoggerManager.LOG.info("After getting secured request");
        return secureRequest;
    }

    public static String wrap(SecretKey secretKey) throws Exception {
        Cipher cipherWrap = Cipher.getInstance(RSA_TRANSFORMATION, Security.getProvider("SunJCE"));
        cipherWrap.init(3, EncryptManagementUtil.getRecieverPublicKey());
        byte[] encryptedKeyBuf = cipherWrap.wrap(secretKey);
        return Base64Utils.base64Encode(encryptedKeyBuf);
    }

    public static PublicKey getRecieverPublicKey() throws Exception {
        InputStream pubKeyFile = EncryptManagementUtil.class.getResourceAsStream("/resources/config/IncomeTaxPublicKey.cer");
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate cert = cf.generateCertificate(pubKeyFile);
        PublicKey pub = cert.getPublicKey();
        pubKeyFile.close();
        return pub;
    }

    public static String getRequestDtlsXmlStr(DitRequest request, SecretKey secretKey) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"com.itd.efiling.offline.common.webservice.request");
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        StringWriter stringWriter = new StringWriter();
        jaxbMarshaller.marshal((Object)request, (Writer)stringWriter);
        String requestDtlsXmlStr = stringWriter.toString();
        LoggerManager.LOG.fine("requestDtlsXmlStr : " + requestDtlsXmlStr);
        return requestDtlsXmlStr;
    }

    public static String encrypt(String stringToEncrypt) throws Exception {
        PublicKey pub = EncryptManagementUtil.getRecieverPublicKey();
        Cipher cipher = Cipher.getInstance(RSA_TRANSFORMATION, Security.getProvider("SunJCE"));
        cipher.init(1, pub);
        byte[] cipherText = cipher.doFinal(stringToEncrypt.getBytes());
        return Base64Utils.base64Encode(cipherText);
    }
}

