/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.util;

import com.itd.efiling.offline.common.exception.CsvImportValidationException;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.util.DateUtil;
import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class CommonUtil {
    private static final AtomicInteger ATOMIC_INTEGER = new AtomicInteger(100);

    public static int getAtomicStlNo() {
        return ATOMIC_INTEGER.getAndIncrement();
    }

    public static Object getTypedValue(String value, String type, int index, String headerName) {
        try {
            value = CommonUtil.getPrintableChar(value);
            if (type == null) {
                return value;
            }
            if ("Date".equals(type)) {
                return DateUtil.toDate(value);
            }
            if ("BigDecimal".equals(type)) {
                if (!ValidationUtil.isObjectEmpty(value)) {
                    return new BigDecimal(value);
                }
            } else if ("BigInteger".equals(type)) {
                if (!ValidationUtil.isObjectEmpty(value)) {
                    return new BigInteger(value);
                }
            } else if ("AUTOCAPS".equals(type)) {
                if (!ValidationUtil.isObjectEmpty(value)) {
                    return value.toUpperCase();
                }
                return value;
            }
        }
        catch (Exception ex) {
            LoggerManager.LOG.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            String errorMessage = "Value : " + value + " is Invalid";
            throw new CsvImportValidationException(errorMessage, index, headerName);
        }
        return null;
    }

    public static String fyToAy(String financialYr) {
        if (financialYr != null && !financialYr.equals(-1)) {
            int ay = Integer.parseInt(financialYr) + 1;
            return String.valueOf(ay);
        }
        return null;
    }

    public static String getRelativeTarget(String valRowEditorPaneTarget, String fieldTarget) {
        return fieldTarget.substring(valRowEditorPaneTarget.length() + 1);
    }

    public static void printStackTrace(Object object) {
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        LoggerManager.LOG.info("object : " + object);
        for (StackTraceElement stackTraceElement : ste) {
            LoggerManager.LOG.info(" : " + stackTraceElement);
        }
    }

    public static void downloadTemplate(String sourceFile, File destinationFile) throws IOException {
        LoggerManager.LOG.info("Inside copyFile for {} " + destinationFile);
        BufferedInputStream bis = new BufferedInputStream(CommonUtil.class.getResourceAsStream(sourceFile));
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destinationFile));
        byte[] readBytes = new byte[1024];
        int lengthRead = bis.read(readBytes);
        while (lengthRead != -1) {
            bos.write(readBytes, 0, lengthRead);
            lengthRead = bis.read(readBytes);
        }
        bis.close();
        bos.close();
    }

    public static String getPrintableChar(String field) {
        if (ValidationUtil.isObjectEmpty(field)) {
            return field;
        }
        String finalField = field;
        char[] saras = field.toCharArray();
        for (int i = 0; i < saras.length; ++i) {
            if (CommonUtil.isPrintableChar(saras[i])) continue;
            LoggerManager.LOG.info("invalid Char for value " + finalField);
            finalField = field.replace(saras[i], ' ');
            LoggerManager.LOG.info("valid Char for value " + finalField);
        }
        return finalField;
    }

    public static boolean isPrintableChar(char field) {
        char saras = field;
        if (saras >= ' ' && saras <= '~') {
            return true;
        }
        LoggerManager.LOG.info("saras : " + saras);
        return false;
    }
}

