/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.player.ctrl;

import com.itd.efiling.offline.common.config.Configs;
import com.itd.efiling.offline.common.dialog.MessageDialogCtrl;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.player.ctrl.FormPlayerController;
import com.itd.efiling.offline.common.reference.holders.RefHolders;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class ThreeRedLightsIlluminate
extends Application {
    public void start(Stage stage) throws Exception {
        FXMLLoader loader = new FXMLLoader(ThreeRedLightsIlluminate.class.getResource("FormPlayer.fxml"));
        Parent root = (Parent)loader.load();
        FormPlayerController controller = (FormPlayerController)loader.getController();
        LoggerManager.LOG.fine("controller : " + controller);
        Scene scene = new Scene(root);
        Rectangle2D rectangle2D = Screen.getPrimary().getVisualBounds();
        double windowWidth = rectangle2D.getWidth();
        double height = rectangle2D.getHeight();
        stage.setHeight(height);
        stage.setWidth(windowWidth);
        String css = ThreeRedLightsIlluminate.class.getResource(Configs.getConfigProperty("utility.css")).toExternalForm();
        scene.getStylesheets().add((Object)css);
        String calenderCss = ThreeRedLightsIlluminate.class.getResource(Configs.getConfigProperty("calender.css")).toExternalForm();
        scene.getStylesheets().add((Object)calenderCss);
        stage.setScene(scene);
        stage.setTitle(Configs.getConfigProperty("utility.name"));
        stage.getIcons().add((Object)new Image(ThreeRedLightsIlluminate.class.getResourceAsStream(Configs.getConfigProperty("utility.icon"))));
        stage.show();
        RefHolders.scene = scene;
        RefHolders.stage = stage;
        RefHolders.hostServices = this.getHostServices();
        stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent t) {
                MessageDialogCtrl.closeUtility();
                LoggerManager.LOG.info(" Close Event " + t);
                t.consume();
            }
        });
    }

    public static void main(String[] args) {
        ThreeRedLightsIlluminate.launch((String[])args);
    }
}

