/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.player.ctrl;

import com.itd.efiling.offline.common.config.Configs;
import com.itd.efiling.offline.common.dialog.MessageDialog;
import com.itd.efiling.offline.common.dialog.MessageDialogCtrl;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.onchange.util.OnChangeCommonUtil;
import com.itd.efiling.offline.common.player.ctrl.Form;
import com.itd.efiling.offline.common.player.ctrl.SubmitFormController;
import com.itd.efiling.offline.common.reference.holders.RefHolders;
import com.itd.efiling.offline.common.util.JfxCommonUtil;
import com.itd.efiling.offline.common.util.XmlUtil;
import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import com.itd.efiling.offline.common.validation.validators.ValidatorInteface;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javax.xml.bind.JAXBException;
import org.xml.sax.SAXException;

public class FormPlayerController
implements Initializable {
    @FXML
    ScrollPane scrollPane;
    @FXML
    StackPane formContainer;
    @FXML
    VBox progressDialog;
    @FXML
    VBox msgContainer;
    @FXML
    Label status;
    @FXML
    Label pageNo;
    @FXML
    Label formName;
    @FXML
    Button saveBtn;
    @FXML
    Button validateBtn;
    @FXML
    Button genBtn;
    @FXML
    Button prevBtn;
    @FXML
    Button nxtBtn;
    @FXML
    Button submitBtn;
    @FXML
    Button previewBtn;
    @FXML
    Button newBtn;
    public static Form form;
    public static boolean flag;

    @FXML
    private void handleClose(Event e) {
        MessageDialogCtrl.closeUtility();
    }

    @FXML
    private void newForm(Event e) {
        this.initNewForm(null);
    }

    public void enableSubmitBtn() {
        this.submitBtn.setVisible(true);
    }

    public void enablePreviewBtn() {
        this.previewBtn.setVisible(true);
    }

    @FXML
    private void newform1(Event e) {
        try {
            this.newBtn.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent keyEvent) {
                    if (keyEvent.getCode() == KeyCode.ENTER) {
                        if (!flag) {
                            MessageDialog.Answer opt = MessageDialogCtrl.getConfirmationDialog("Confirmation", "Do you want to save ITR form ?");
                            if (opt.equals((Object)MessageDialog.Answer.NO)) {
                                FormPlayerController.this.initNewForm(null);
                                flag = true;
                                MessageDialogCtrl.displayInfoDialog("Info", "1. Please read the Help and Instructions before you start entering the data.\n2. Please check for the latest version of the utility.\n3. Please login to e-Filing portal and go to My Account --> Download Prefilled XML. The downloaded XML can be imported to prefill the data.\n");
                            } else if (opt.equals((Object)MessageDialog.Answer.YES_OK)) {
                                ValidationUtil.formValidate();
                                LoggerManager.LOG.info("End validate");
                                ValidatorInteface.focusFirstError();
                                if (ValidatorInteface.isValidationSuccess() && !ValidatorInteface.hasImportErrors()) {
                                    MessageDialogCtrl.displayInfoDialog("Success", "Form validated successfully.");
                                }
                                if (ValidatorInteface.isValidationSuccess() && !ValidatorInteface.hasImportErrors()) {
                                    try {
                                        XmlUtil.generateXml(form, false);
                                    }
                                    catch (IOException e1) {
                                        e1.printStackTrace();
                                    }
                                    catch (JAXBException e1) {
                                        e1.printStackTrace();
                                    }
                                    catch (SAXException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                            }
                        } else {
                            FormPlayerController.this.initNewForm(null);
                            flag = true;
                            MessageDialogCtrl.displayInfoDialog("Info", "1. Please read the Help and Instructions before you start entering the data.\n2. Please check for the latest version of the utility.\n3. Please login to e-Filing portal and go to My Account --> Download Prefilled XML. The downloaded XML can be imported to prefill the data.\n");
                        }
                    }
                }
            });
            this.newBtn.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    LoggerManager.LOG.info("flg value :: " + flag);
                    if (!flag) {
                        MessageDialog.Answer opt = MessageDialogCtrl.getConfirmationDialog("Confirmation", "Do you want to save ITR form ?");
                        if (opt.equals((Object)MessageDialog.Answer.NO)) {
                            FormPlayerController.this.initNewForm(null);
                            flag = true;
                            MessageDialogCtrl.displayInfoDialog("Info", "1. Please read the Help and Instructions before you start entering the data.\n2. Please check for the latest version of the utility.\n3. Please login to e-Filing portal and go to My Account --> Download Prefilled XML. The downloaded XML can be imported to prefill the data.\n");
                        } else if (opt.equals((Object)MessageDialog.Answer.YES_OK)) {
                            ValidationUtil.formValidate();
                            LoggerManager.LOG.info("End validate");
                            ValidatorInteface.focusFirstError();
                            if (ValidatorInteface.isValidationSuccess() && !ValidatorInteface.hasImportErrors()) {
                                MessageDialogCtrl.displayInfoDialog("Success", "Form validated successfully.");
                            }
                            if (ValidatorInteface.isValidationSuccess() && !ValidatorInteface.hasImportErrors()) {
                                try {
                                    XmlUtil.generateXml(form, false);
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                                catch (JAXBException e1) {
                                    e1.printStackTrace();
                                }
                                catch (SAXException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                    } else {
                        FormPlayerController.this.initNewForm(null);
                        flag = true;
                        MessageDialogCtrl.displayInfoDialog("Info", "1. Please read the Help and Instructions before you start entering the data.\n2. Please check for the latest version of the utility.\n3. Please login to e-Filing portal and go to My Account --> Download Prefilled XML. The downloaded XML can be imported to prefill the data.\n");
                    }
                }
            });
        }
        catch (Throwable ex) {
            LoggerManager.LOG.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        LoggerManager.LOG.info("msgContainer : " + this.msgContainer + " scrollPane " + this.scrollPane);
        RefHolders.msgContainer = this.msgContainer;
        RefHolders.scrollPane = this.scrollPane;
        RefHolders.formPlayerController = this;
        this.initNewForm(null);
        flag = true;
    }

    public void setFormControls() {
        if (form != null) {
            this.pageNo.setText("(Page 1 of " + form.getTabPane().getTabs().size() + ")");
            form.getTabPane().getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
                    FormPlayerController.this.pageNo.setText("(Page " + (t1.intValue() + 1) + " of " + form.getTabPane().getTabs().size() + ")");
                }
            });
            this.saveBtn.setDisable(false);
            this.validateBtn.setDisable(false);
            this.genBtn.setDisable(false);
            this.prevBtn.setDisable(false);
            this.nxtBtn.setDisable(false);
            this.submitBtn.setDisable(false);
            this.previewBtn.setDisable(false);
            this.newBtn.setDisable(false);
        }
    }

    @FXML
    public void validate(Event e) {
        try {
            OnChangeCommonUtil.executeOnChangeMethodForxmlGen(ValidationUtil.ALL_FIELDS_MAP.get("submit.call"));
            LoggerManager.LOG.info("Start validate");
            ValidationUtil.formValidate();
            LoggerManager.LOG.info("End validate");
            ValidatorInteface.focusFirstError();
            if (ValidatorInteface.isValidationSuccess() && !ValidatorInteface.hasImportErrors()) {
                MessageDialogCtrl.displayInfoDialog("Success", "Form validated successfully.");
            }
        }
        catch (Throwable ex) {
            LoggerManager.LOG.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }

    @FXML
    public void generateXml(Event e) {
        try {
            if (form == null) {
                return;
            }
            OnChangeCommonUtil.executeOnChangeMethodForxmlGen(ValidationUtil.ALL_FIELDS_MAP.get("submit.call"));
            this.validate(e);
            if (ValidatorInteface.isValidationSuccess() && !ValidatorInteface.hasImportErrors()) {
                XmlUtil.generateXml(form, false);
            }
        }
        catch (Throwable ex) {
            LoggerManager.LOG.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            MessageDialogCtrl.displayErrorDialog("XML generation failed");
        }
    }

    @FXML
    public void saveDraft(Event e) {
        try {
            if (form == null) {
                return;
            }
            XmlUtil.saveDraft(form);
        }
        catch (Throwable ex) {
            LoggerManager.LOG.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            MessageDialogCtrl.displayErrorDialog("XML generation failed");
        }
    }

    @FXML
    public void gotoNextTab(Event e) {
        if (form != null && form.getTabPane() != null) {
            int selectedIndex = form.getTabPane().getSelectionModel().getSelectedIndex();
            ObservableList list = form.getTabPane().getTabs();
            if (list.size() > selectedIndex + 1 && ((Tab)list.get(selectedIndex + 1)).isDisabled()) {
                return;
            }
            form.getTabPane().getSelectionModel().selectNext();
            this.scrollPane.setVvalue(0.0);
        }
    }

    @FXML
    public void gotoPrevTab(Event e) {
        if (form != null && form.getTabPane() != null) {
            form.getTabPane().getSelectionModel().selectPrevious();
            this.scrollPane.setVvalue(0.0);
        }
    }

    public void openForm(Event e) {
        try {
            if (form != null) {
                if (!flag) {
                    MessageDialog.Answer opt = MessageDialogCtrl.getConfirmationDialog("Confirmation", "Do you want to save ITR form ?");
                    if (opt.equals((Object)MessageDialog.Answer.NO)) {
                        File xmlFile = JfxCommonUtil.openFileDialog(".open", "Open");
                        if (xmlFile != null) {
                            LoggerManager.LOG.info("xmlFilexmlFile {}" + xmlFile);
                            Object entity = XmlUtil.unmarshal(xmlFile);
                            LoggerManager.LOG.info("entityentity {}" + entity);
                            if (entity != null) {
                                MessageDialogCtrl.displayInfoDialog("Info", "You have successfully imported the  data you saved. Request you to review and re-calculate.");
                                this.initNewForm(entity);
                                flag = true;
                                MessageDialogCtrl.displayInfoDialog("Info", "1. Please read the Help and Instructions before you start entering the data.\n2. Please check for the latest version of the utility.\n3. Please login to e-Filing portal and go to My Account --> Download Prefilled XML. The downloaded XML can be imported to prefill the data.\n");
                            } else {
                                MessageDialogCtrl.displayErrorDialog("Invalid ITR or Assessment Year");
                            }
                            return;
                        }
                    } else if (opt.equals((Object)MessageDialog.Answer.YES_OK)) {
                        ValidationUtil.formValidate();
                        LoggerManager.LOG.info("End validate");
                        ValidatorInteface.focusFirstError();
                        if (ValidatorInteface.isValidationSuccess() && !ValidatorInteface.hasImportErrors()) {
                            MessageDialogCtrl.displayInfoDialog("Success", "Form validated successfully.");
                        }
                        if (ValidatorInteface.isValidationSuccess() && !ValidatorInteface.hasImportErrors()) {
                            try {
                                XmlUtil.generateXml(form, false);
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                            catch (JAXBException e1) {
                                e1.printStackTrace();
                            }
                            catch (SAXException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                } else {
                    File xmlFile = JfxCommonUtil.openFileDialog(".open", "Open");
                    LoggerManager.LOG.info("FILE ::" + xmlFile);
                    if (xmlFile != null) {
                        LoggerManager.LOG.info("xmlFilexmlFile {}" + xmlFile);
                        Object entity = XmlUtil.unmarshal(xmlFile);
                        LoggerManager.LOG.info("entityentity {}" + entity);
                        if (entity != null) {
                            MessageDialogCtrl.displayInfoDialog("Info", "You have successfully imported the  data you saved. Request you to review and re-calculate.");
                            this.initNewForm(entity);
                            MessageDialogCtrl.displayInfoDialog("Info", "1. Please read the Help and Instructions before you start entering the data.\n2. Please check for the latest version of the utility.\n3. Please login to e-Filing portal and go to My Account --> Download Prefilled XML. The downloaded XML can be imported to prefill the data.\n");
                            flag = true;
                            this.submitBtn.setDisable(false);
                        } else {
                            MessageDialogCtrl.displayErrorDialog("Invalid ITR or Assessment Year");
                        }
                        return;
                    }
                }
                LoggerManager.LOG.info("Start open");
            }
            LoggerManager.LOG.info("End open");
        }
        catch (Throwable ex) {
            LoggerManager.LOG.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            MessageDialogCtrl.displayErrorDialog("ITR is validated with errors.Please verify/rectify from the right pane and proceed.");
        }
    }

    public void generateXmlForm(Event e) {
        if (form == null) {
            return;
        }
        OnChangeCommonUtil.executeOnChangeMethodForxmlGen(ValidationUtil.ALL_FIELDS_MAP.get("submit.call"));
        ValidationUtil.formValidate();
        LoggerManager.LOG.info("End validate");
        ValidatorInteface.focusFirstError();
        if (ValidatorInteface.isValidationSuccess() && !ValidatorInteface.hasImportErrors()) {
            MessageDialogCtrl.displayInfoDialog("Success", "Form validated successfully");
        }
        if (ValidatorInteface.isValidationSuccess() && !ValidatorInteface.hasImportErrors()) {
            try {
                XmlUtil.generateXml(form, false);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            catch (JAXBException e1) {
                e1.printStackTrace();
            }
            catch (SAXException e1) {
                e1.printStackTrace();
            }
        }
    }

    @FXML
    public void saveDraftForm(Event e) {
        LoggerManager.LOG.info("Insid");
        try {
            if (form == null) {
                return;
            }
            XmlUtil.saveDraft(form);
        }
        catch (Throwable ex) {
            LoggerManager.LOG.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            MessageDialogCtrl.displayErrorDialog("XML generation failed");
        }
    }

    @FXML
    public void open(Event e) {
        try {
            MessageDialog.Answer opt;
            if (form != null && form.isChanged() && (opt = MessageDialogCtrl.getConfirmationDialog("Confirmation", "Do you wish to open a new form ?")).equals((Object)MessageDialog.Answer.NO)) {
                return;
            }
            LoggerManager.LOG.info("Start open");
            File xmlFile = JfxCommonUtil.openFileDialog(".open", "Open");
            if (xmlFile != null) {
                Object entity = XmlUtil.unmarshal(xmlFile);
                if (entity != null) {
                    this.initNewForm(entity);
                } else {
                    MessageDialogCtrl.displayErrorDialog("Please select a valid file");
                }
            }
            LoggerManager.LOG.info("End open");
        }
        catch (Throwable ex) {
            LoggerManager.LOG.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            MessageDialogCtrl.displayErrorDialog("Please select a valid file");
        }
    }

    public void initNewForm(final Object entity) {
        this.msgContainer.getChildren().clear();
        this.formContainer.getChildren().clear();
        this.progressDialog.setVisible(true);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (form != null) {
                    form.scaleXProperty().unbind();
                    form.scaleYProperty().unbind();
                }
                String className = Configs.getConfigProperty("form.implementor");
                try {
                    form = (Form)((Object)Class.forName(className).newInstance());
                }
                catch (Exception ex) {
                    LoggerManager.LOG.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
                    Platform.exit();
                }
                if (entity != null) {
                    form.load(entity);
                }
                FormPlayerController.this.status.textProperty().bind((ObservableValue)form.statusProperty());
                FormPlayerController.this.scrollPane.setFitToWidth(false);
                FormPlayerController.this.formContainer.setPrefSize((double)Configs.getIntConfigProperty("form.prefWidth"), (double)Configs.getIntConfigProperty("form.prefHeight"));
                FormPlayerController.this.formContainer.setPrefHeight((double)Configs.getIntConfigProperty("form.prefHeight"));
                FormPlayerController.this.formContainer.getChildren().add((Object)form);
                FormPlayerController.this.formName.setText(Configs.getConfigProperty("form.name"));
                FormPlayerController.this.setFormControls();
                FormPlayerController.this.progressDialog.setVisible(false);
            }
        });
    }

    @FXML
    public void submitFile(Event e) {
        try {
            if (form == null) {
                return;
            }
            this.validate(e);
            if (ValidatorInteface.isValidationSuccess() && !ValidatorInteface.hasImportErrors()) {
                XmlUtil.generateXml(form, true);
                SubmitFormController.openSubmitDialog();
            }
        }
        catch (Throwable ex) {
            LoggerManager.LOG.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            MessageDialogCtrl.displayErrorDialog("XML generation failed");
        }
    }

    @FXML
    public void Preview(Event e) {
        this.previewBtn.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.ENTER) {
                    // empty if block
                }
            }
        });
        this.previewBtn.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                Properties prop = new Properties();
                try {
                    Parent root = (Parent)FXMLLoader.load((URL)this.getClass().getClassLoader().getResource(FormPlayerController.form.previewURL));
                    Scene scene = new Scene(root);
                    Stage stage = new Stage();
                    stage.setTitle("Preview page");
                    Rectangle2D rectangle2D = Screen.getPrimary().getVisualBounds();
                    double windowWidth = rectangle2D.getWidth();
                    double height = rectangle2D.getHeight();
                    stage.setHeight(height);
                    stage.setWidth(windowWidth);
                    stage.setScene(scene);
                    stage.show();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        Stage stage = new Stage();
        VBox root = new VBox(10.0);
        root.setPrefSize(400.0, 250.0);
        root.setStyle("-fx-padding: 10;-fx-border-style: solid inside;-fx-border-width: 2;-fx-border-insets: 5;-fx-border-radius: 5;-fx-border-color: blue;");
        Scene scene = new Scene((Parent)root);
        stage.setScene(scene);
        stage.setTitle("Showing all Printers");
    }

    @FXML
    public void openHelp() {
        try {
            Parent root = (Parent)FXMLLoader.load((URL)this.getClass().getClassLoader().getResource(Configs.getConfigProperty("path") + "/Help.fxml"));
            Scene scene = new Scene(root, 500.0, 500.0);
            Stage stage = new Stage();
            stage.setTitle("Help");
            stage.setHeight(500.0);
            stage.setWidth(500.0);
            stage.setScene(scene);
            stage.show();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void openFeatures() {
        try {
            Parent root = (Parent)FXMLLoader.load((URL)this.getClass().getClassLoader().getResource(Configs.getConfigProperty("path") + "/AccessibilityFeatures.fxml"));
            Scene scene = new Scene(root, 500.0, 500.0);
            Stage stage = new Stage();
            stage.setTitle("Accessibility Features");
            stage.setHeight(500.0);
            stage.setWidth(500.0);
            stage.setScene(scene);
            stage.show();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void openOptions() {
        try {
            Parent root = (Parent)FXMLLoader.load((URL)this.getClass().getClassLoader().getResource(Configs.getConfigProperty("path") + "/AccessibilityOptions.fxml"));
            Scene scene = new Scene(root, 500.0, 500.0);
            Stage stage = new Stage();
            stage.setTitle("Accessibility Options");
            stage.setHeight(500.0);
            stage.setWidth(500.0);
            stage.setScene(scene);
            stage.show();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void openAbout() {
        try {
            Parent root = (Parent)FXMLLoader.load((URL)this.getClass().getClassLoader().getResource(Configs.getConfigProperty("path") + "/About.fxml"));
            Scene scene = new Scene(root, 400.0, 300.0);
            Stage stage = new Stage();
            stage.setTitle("Help");
            stage.setHeight(300.0);
            stage.setWidth(550.0);
            stage.setScene(scene);
            stage.show();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        flag = true;
    }
}

