/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.onchange.util;

import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.onchange.util.OnChangeFunctions;
import com.itd.efiling.offline.common.player.ctrl.Form;
import com.itd.efiling.offline.common.reference.holders.RefHolders;
import com.itd.efiling.offline.common.util.DataTransporter;
import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import com.itd.efiling.offline.javafx.ui.components.ValidationAware;
import java.lang.reflect.Method;
import java.util.logging.Level;

public class OnChangeCommonUtil {
    private OnChangeCommonUtil() {
    }

    public static void executeOnChangeMethod(String target, Object data) {
        Method onChangeMethod = OnChangeFunctions.getOnChange(target);
        if (onChangeMethod == null) {
            return;
        }
        ValidationAware field = ValidationUtil.ALL_FIELDS_MAP.get(target);
        field.setData(data);
        OnChangeCommonUtil.executeOnChangeMethod(field);
    }

    public static void executeOnChangeMethod(ValidationAware field) {
        String target = field.getTarget();
        Method onChangeMethod = OnChangeFunctions.getOnChange(target);
        if (onChangeMethod == null || RefHolders.loading) {
            return;
        }
        try {
            onChangeMethod.invoke(null, field);
        }
        catch (Throwable ex) {
            LoggerManager.LOG.info("Error While executeOnChangeMethod for field ... " + field);
            LoggerManager.LOG.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }

    public static Object getElementValueByTargetName(String target) {
        if (ValidationUtil.ALL_FIELDS_MAP.containsKey(target)) {
            return ValidationUtil.ALL_FIELDS_MAP.get(target).getData();
        }
        return null;
    }

    public static void setElementValueByTargetName(String target, Object data) {
        if (ValidationUtil.ALL_FIELDS_MAP.containsKey(target)) {
            ValidationUtil.ALL_FIELDS_MAP.get(target).setData(data);
            OnChangeCommonUtil.setTargetValueByTargetName(target, data);
        }
    }

    public static Object getTargetValueByTargetName(String target) {
        return DataTransporter.getObjectFromPath((Object)Form.getForm(), target);
    }

    public static void setTargetValueByTargetName(String target, Object data) {
        DataTransporter.transferDataToBean((Object)Form.getForm(), target, data);
    }

    public static ValidationAware getFieldByTargetName(String target) {
        return ValidationUtil.ALL_FIELDS_MAP.get(target);
    }

    public static void executeOnChangeMethodForxmlGen(ValidationAware field) {
        Method onChangeMethod = OnChangeFunctions.getOnChange("form_xml_gen");
        LoggerManager.LOG.info("onChangeMethod  in executeOnChangeMethodForXmlGEn   ... " + onChangeMethod);
        if (onChangeMethod == null || RefHolders.loading) {
            return;
        }
        try {
            onChangeMethod.invoke(null, field);
        }
        catch (Throwable ex) {
            LoggerManager.LOG.info("Error While executeOnChangeMethod for field ... " + field);
            LoggerManager.LOG.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }
}

