/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.dsc.util;

import com.itd.efiling.offline.common.logging.util.LoggerManager;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Locale;

public class DscValidationUtil {
    private static String getPanHashFromDsc(X509Certificate x509Certificate) {
        Principal principal = x509Certificate.getSubjectDN();
        LoggerManager.LOG.fine("principal.getName() :- {}" + principal.getName());
        String[] principalArray = principal.getName().split(",");
        String panHash = null;
        String cname = null;
        for (int i = 0; i < principalArray.length; ++i) {
            principalArray[i] = principalArray[i].trim();
            LoggerManager.LOG.fine("principalArray[i]:- {}" + principalArray[i]);
            if (principalArray[i].startsWith("SERIALNUMBER")) {
                panHash = principalArray[i].substring(principalArray[i].indexOf("=") + 1);
                LoggerManager.LOG.fine("strSerialNo:- {} " + panHash);
            }
            if (!principalArray[i].startsWith("CN")) continue;
            cname = principalArray[i].substring(principalArray[i].indexOf("=") + 1);
            LoggerManager.LOG.fine("Common name:- {} " + cname);
        }
        if ((panHash == null || panHash.equals("")) && cname != null && !cname.equals("") && cname.indexOf("+") != -1) {
            LoggerManager.LOG.fine("common name block ");
            panHash = DscValidationUtil.getPanHash(cname);
        }
        LoggerManager.LOG.fine("---panHash from getSerialNo from Pan --> :- {}" + panHash);
        return panHash;
    }

    private static String getPanHash(String cname) {
        String panHash = null;
        if (cname != null && !cname.equals("") && cname.indexOf("+") != -1) {
            String cname1 = cname.substring(cname.indexOf("+") + 1);
            LoggerManager.LOG.fine("Cname after finding + {}" + cname);
            cname1 = cname1.trim();
            if (cname1.startsWith("SERIALNUMBER")) {
                panHash = cname1.substring(cname1.indexOf("=") + 1);
                LoggerManager.LOG.fine("serial number from second option:- {}" + panHash);
            }
        }
        return panHash;
    }

    public static final boolean isPanHashValid(X509Certificate x509Certificate, String verfierPanNumber) throws NoSuchAlgorithmException {
        String panHashFromDsc = DscValidationUtil.getPanHashFromDsc(x509Certificate);
        if (panHashFromDsc == null) {
            LoggerManager.LOG.severe("PAN HASH NOT PRESENT IN DSC");
            return true;
        }
        boolean isValid = false;
        String keyPerPanHash = DscValidationUtil.sha256Hex(verfierPanNumber.toUpperCase(Locale.US));
        if (panHashFromDsc != null && panHashFromDsc.equalsIgnoreCase(keyPerPanHash)) {
            isValid = true;
        }
        if (!isValid) {
            LoggerManager.LOG.severe("                 PAN HASH VALIDATION FAILED        ");
            LoggerManager.LOG.severe("verfierPanNumber         :-      " + verfierPanNumber);
            LoggerManager.LOG.severe("keyPerPanHash            :-      " + keyPerPanHash);
            LoggerManager.LOG.severe("panHashFromDsc           :-      " + panHashFromDsc);
        }
        return isValid;
    }

    private static String sha256Hex(String data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(data.getBytes());
        return DscValidationUtil.bytesToHex(md.digest());
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuffer result = new StringBuffer();
        for (byte byt : bytes) {
            result.append(Integer.toString((byt & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    public static X509Certificate getX509Certificate(String certFilename) throws Exception {
        FileInputStream fr = new FileInputStream(certFilename);
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        return (X509Certificate)cf.generateCertificate(fr);
    }
}

