/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.dialog.ctrl;

import com.itd.efiling.offline.common.config.Configs;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.reference.holders.RefHolders;
import java.net.URL;
import java.util.logging.Level;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;

public class CommonDialog
extends Stage {
    public Object dialogController;
    private EventHandler<KeyEvent> eventHandler;

    public CommonDialog() {
    }

    public CommonDialog(boolean modality, String title, URL fxmlUrl) {
        try {
            LoggerManager.LOG.info("CommonDialog starts");
            this.initOwner((Window)RefHolders.stage);
            FXMLLoader loader = new FXMLLoader(fxmlUrl);
            Modality m = modality ? Modality.APPLICATION_MODAL : Modality.NONE;
            this.initModality(m);
            this.setTitle(title);
            Parent root = (Parent)loader.load();
            Scene scene = new Scene(root);
            String css = CommonDialog.class.getResource(Configs.getConfigProperty("utility.css")).toExternalForm();
            scene.getStylesheets().add((Object)css);
            String calenderCss = CommonDialog.class.getResource(Configs.getConfigProperty("calender.css")).toExternalForm();
            scene.getStylesheets().add((Object)calenderCss);
            this.setScene(scene);
            this.dialogController = loader.getController();
            LoggerManager.LOG.info("CommonDialog ends");
            this.addEventHandler(KeyEvent.KEY_PRESSED, this.getEventHandlerC());
        }
        catch (Exception e) {
            LoggerManager.LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public EventHandler<KeyEvent> getEventHandlerC() {
        if (this.eventHandler == null) {
            this.eventHandler = new EventHandler<KeyEvent>(){

                public void handle(KeyEvent e) {
                    if (e.getCode() == KeyCode.ESCAPE) {
                        CommonDialog.this.hide();
                    }
                }
            };
        }
        return this.eventHandler;
    }

    public <Controller> Controller getController() {
        return (Controller)this.dialogController;
    }
}

