/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.config;

import com.itd.efiling.offline.common.logging.util.LoggerManager;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class ErrorMessages {
    private static final Map<String, String> ERROR_MESSAGES = new LinkedHashMap<String, String>();

    private static void setErrorMessages() {
        try {
            Properties properties = new Properties();
            properties.load(ErrorMessages.class.getResourceAsStream("/resources/config/ErrorMessages.properties"));
            Set<Object> keys = properties.keySet();
            for (Object obj : keys) {
                String key = (String)obj;
                String errorMessage = properties.getProperty(key);
                ERROR_MESSAGES.put(key, errorMessage);
            }
        }
        catch (Exception e) {
            LoggerManager.LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public static String getError(String key) {
        if (ERROR_MESSAGES.containsKey(key)) {
            return ERROR_MESSAGES.get(key);
        }
        return key;
    }

    public static String getStringValue(String key) {
        return ErrorMessages.getError(key);
    }

    static {
        ErrorMessages.setErrorMessages();
    }
}

