/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.config;

import com.itd.efiling.offline.common.logging.util.LoggerManager;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class Configs {
    private static final Map<String, String> CONFIG_PROPERTIES = new LinkedHashMap<String, String>();

    private Configs() {
    }

    private static void load() {
        try {
            Properties properties = new Properties();
            properties.load(Configs.class.getResourceAsStream("/resources/config/Configuration.properties"));
            Set<String> keys = properties.stringPropertyNames();
            for (String key : keys) {
                String value = properties.getProperty(key);
                CONFIG_PROPERTIES.put(key, value);
            }
        }
        catch (Exception e) {
            LoggerManager.LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public static String getConfigProperty(String key) {
        if (CONFIG_PROPERTIES.containsKey(key)) {
            return CONFIG_PROPERTIES.get(key);
        }
        return key;
    }

    public static int getIntConfigProperty(String key) {
        if (CONFIG_PROPERTIES.containsKey(key)) {
            return Integer.parseInt(CONFIG_PROPERTIES.get(key));
        }
        return 0;
    }

    static {
        Configs.load();
    }
}

