/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.config;

import com.itd.efiling.offline.common.config.Configs;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.javafx.ui.components.Option;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;

public class ComboBoxOptionsCacher {
    private static Map<String, List<Option<String, String>>> COMBO_BOX_OPTIONS = new LinkedHashMap<String, List<Option<String, String>>>();
    private static Map<String, Map<String, String>> COMBO_BOX_OPTIONS_MAP = new LinkedHashMap<String, Map<String, String>>();
    private static Map<String, String> COMBO_BOX_REUSE_MAP = new LinkedHashMap<String, String>();

    private static void setComboBoxOptions() {
        try {
            Properties prop = new Properties();
            prop.load(ComboBoxOptionsCacher.class.getResourceAsStream(Configs.getConfigProperty("comboboxvalues.properties")));
            Set<String> propKeys = prop.stringPropertyNames();
            TreeMap<String, String> propMap = new TreeMap<String, String>();
            for (String key : propKeys) {
                propMap.put(key, prop.getProperty(key));
            }
            Iterator<String> iterator = propMap.keySet().iterator();
            while (iterator.hasNext()) {
                String[] keyValue;
                String key;
                String finalKey = key = iterator.next();
                if (key.indexOf(".") != -1) {
                    finalKey = key.substring(0, key.lastIndexOf("."));
                }
                if ((keyValue = ((String)propMap.get(key)).split("\\^")).length == 1) {
                    COMBO_BOX_REUSE_MAP.put(key, keyValue[0]);
                    continue;
                }
                if (!COMBO_BOX_OPTIONS.containsKey(finalKey)) {
                    COMBO_BOX_OPTIONS.put(finalKey, new LinkedList());
                }
                if (!COMBO_BOX_OPTIONS_MAP.containsKey(finalKey)) {
                    COMBO_BOX_OPTIONS_MAP.put(finalKey, new LinkedHashMap());
                }
                COMBO_BOX_OPTIONS.get(finalKey).add(new Option<String, String>(keyValue[0], keyValue[1]));
                COMBO_BOX_OPTIONS_MAP.get(finalKey).put(keyValue[0], keyValue[1]);
            }
        }
        catch (Exception e) {
            LoggerManager.LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public static List<Option<String, String>> getComboOptions(String key) {
        if (COMBO_BOX_REUSE_MAP.containsKey(key)) {
            return ComboBoxOptionsCacher.getComboOptions(COMBO_BOX_REUSE_MAP.get(key).trim());
        }
        if (COMBO_BOX_OPTIONS.containsKey(key)) {
            return COMBO_BOX_OPTIONS.get(key);
        }
        LoggerManager.LOG.severe("Combo Options Not Avaiable For key " + key);
        LinkedList<Option<String, String>> temp = new LinkedList<Option<String, String>>();
        temp.add(new Option<String, String>("-1", "Select"));
        return temp;
    }

    public static Map<String, String> getComboOptionsMap(String key) {
        if (COMBO_BOX_REUSE_MAP.containsKey(key)) {
            return ComboBoxOptionsCacher.getComboOptionsMap(COMBO_BOX_REUSE_MAP.get(key));
        }
        return COMBO_BOX_OPTIONS_MAP.get(key);
    }

    public static boolean containsKey(String target) {
        if (COMBO_BOX_REUSE_MAP.containsKey(target)) {
            return true;
        }
        return COMBO_BOX_OPTIONS.containsKey(target);
    }

    public static String getValue(String target, String key) {
        if (ComboBoxOptionsCacher.isDropDownValueValid(target, key)) {
            return ComboBoxOptionsCacher.getComboOptionsMap(target).get(key);
        }
        return "";
    }

    public static boolean isDropDownValueValid(String key, String value) {
        return ComboBoxOptionsCacher.getComboOptionsMap(key).containsKey(value);
    }

    public static String getValueForKey(String firstKey, String secondKey) {
        return COMBO_BOX_OPTIONS_MAP.get(firstKey).get(secondKey);
    }

    static {
        ComboBoxOptionsCacher.setComboBoxOptions();
    }
}

