/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.codec;

import com.itd.efiling.offline.common.util.Base64Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class XmlDigestUtil {
    private static final String ALGORITHM = "HmacSHA256";
    private static final String UNICODE_FORMAT = "UTF8";
    private static final String DES_ENCRYPTION_SCHEME = "DES";

    public static String createHash(InputStream is, int iteration, String key) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        Mac sha256_HMAC = Mac.getInstance(ALGORITHM);
        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes(), ALGORITHM);
        sha256_HMAC.init(secret_key);
        byte[] bytesBuffer = new byte[2048];
        int bytesRead = -1;
        while ((bytesRead = is.read(bytesBuffer)) != -1) {
            sha256_HMAC.update(bytesBuffer, 0, bytesRead);
        }
        byte[] digestValue = sha256_HMAC.doFinal();
        for (int i = 0; i < iteration; ++i) {
            sha256_HMAC.reset();
            digestValue = sha256_HMAC.doFinal(digestValue);
        }
        String generatedHash = Base64Utils.base64Encode(digestValue);
        return generatedHash;
    }

    public static String decrypt(String encryptedString) {
        String decryptedString = null;
        try {
            DESKeySpec keySpec = new DESKeySpec(XmlDigestUtil.getEncryptionKey());
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(DES_ENCRYPTION_SCHEME);
            SecretKey secretKey = secretKeyFactory.generateSecret(keySpec);
            Cipher cipher = Cipher.getInstance(DES_ENCRYPTION_SCHEME);
            cipher.init(2, secretKey);
            byte[] encryptedText = Base64Utils.base64Decode(encryptedString);
            byte[] plainText = cipher.doFinal(encryptedText);
            decryptedString = new String(plainText);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return decryptedString;
    }

    public static byte[] getEncryptionKey() throws UnsupportedEncodingException {
        return "E-FILING-PASSWORD-ENCRYPTION".getBytes(UNICODE_FORMAT);
    }
}

