/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.codec;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class StringUtils {
    public static final String UTF_8_STR = "UTF-8";
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    private static byte[] getBytes(String string, Charset charset) {
        if (string == null) {
            return null;
        }
        return string.getBytes(charset);
    }

    public static byte[] getBytesUtf8(String string) {
        return StringUtils.getBytes(string, UTF_8);
    }

    private static IllegalStateException newIllegalStateException(String charsetName, UnsupportedEncodingException e) {
        return new IllegalStateException(charsetName + ": " + e);
    }

    private static String newString(byte[] bytes, Charset charset) {
        return bytes == null ? null : new String(bytes, charset);
    }

    public static String newString(byte[] bytes, String charsetName) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw StringUtils.newIllegalStateException(charsetName, e);
        }
    }

    public static String newStringUtf8(byte[] bytes) {
        return StringUtils.newString(bytes, UTF_8);
    }
}

