/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.calendar;

import com.itd.efiling.offline.common.calendar.CalendarView;
import com.itd.efiling.offline.common.calendar.DatePane;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

final class MonthView
extends DatePane {
    private static final String CSS_CALENDAR_MONTH_VIEW = "calendar-month-view";
    private static final String CSS_CALENDAR_DAY_CURRENT_MONTH = "calendar-cell-current-month";
    private static final String CSS_CALENDAR_DAY_OTHER_MONTH = "calendar-cell-other-month";
    private static final String CSS_CALENDAR_TODAY = "calendar-cell-today";
    private static final String CSS_CALENDAR_WEEKDAYS = "calendar-weekdays";
    private static final String CSS_CALENDAR_WEEK_NUMBER = "calendar-week-number";
    private int numberOfDaysPerWeek;

    public MonthView(CalendarView calendarView) {
        super(calendarView);
        this.getStyleClass().add((Object)CSS_CALENDAR_MONTH_VIEW);
        calendarView.localeProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                MonthView.this.updateContent();
            }
        });
        calendarView.getDisabledWeekdays().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                MonthView.this.updateDays();
            }
        });
        calendarView.getDisabledDates().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                MonthView.this.updateDays();
            }
        });
        calendarView.showWeeksProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                MonthView.this.getChildren().clear();
                MonthView.this.buildContent();
                MonthView.this.updateContent();
            }
        });
    }

    @Override
    public void buildContent() {
        int colOffset;
        Calendar calendar = (Calendar)this.calendarView.calendarProperty().get();
        this.numberOfDaysPerWeek = calendar.getMaximum(7);
        int maxNumberOfDaysInMonth = calendar.getMaximum(5);
        int numberOfRows = (int)Math.ceil((double)(maxNumberOfDaysInMonth - 1) / (double)this.numberOfDaysPerWeek) + 1;
        this.getChildren().clear();
        int n = colOffset = this.calendarView.getShowWeeks() ? 1 : 0;
        if (this.calendarView.getShowWeeks()) {
            Label empty = new Label();
            empty.setMaxWidth(Double.MAX_VALUE);
            empty.getStyleClass().add((Object)CSS_CALENDAR_WEEKDAYS);
            this.add((Node)empty, 0, 0);
        }
        for (int i = 0; i < this.numberOfDaysPerWeek; ++i) {
            Label label = new Label();
            label.getStyleClass().add((Object)CSS_CALENDAR_WEEKDAYS);
            label.setMaxWidth(Double.MAX_VALUE);
            label.setAlignment(Pos.CENTER);
            this.add((Node)label, i + colOffset, 0);
        }
        for (int rowIndex = 0; rowIndex < numberOfRows; ++rowIndex) {
            if (this.calendarView.getShowWeeks()) {
                Label label = new Label();
                label.setMaxWidth(Double.MAX_VALUE);
                label.setMaxHeight(Double.MAX_VALUE);
                label.getStyleClass().add((Object)CSS_CALENDAR_WEEK_NUMBER);
                this.add((Node)label, 0, rowIndex + 1);
            }
            for (int colIndex = 0; colIndex < this.numberOfDaysPerWeek; ++colIndex) {
                final Button button = new Button();
                button.setMaxWidth(Double.MAX_VALUE);
                button.setMaxHeight(Double.MAX_VALUE);
                GridPane.setVgrow((Node)button, (Priority)Priority.ALWAYS);
                GridPane.setHgrow((Node)button, (Priority)Priority.ALWAYS);
                button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent actionEvent) {
                        MonthView.this.calendarView.selectedDate.set((Object)((Date)button.getUserData()));
                    }
                });
                this.add((Node)button, colIndex + colOffset, rowIndex + 1);
            }
        }
    }

    @Override
    protected void updateContent() {
        this.updateDays();
        this.updateWeekNames();
    }

    private void updateDays() {
        Calendar calendar = this.calendarView.getCalendar();
        DateFormat dateFormat = DateFormat.getDateInstance(0, (Locale)this.calendarView.localeProperty().get());
        dateFormat.setCalendar(this.calendarView.getCalendar());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(5, 1);
        int month = calendar.get(2);
        Date tmp = calendar.getTime();
        calendar.setTime(new Date());
        int todayDay = calendar.get(5);
        int todayMonth = calendar.get(2);
        int todayYear = calendar.get(1);
        calendar.setTime(tmp);
        while (calendar.getFirstDayOfWeek() != calendar.get(7)) {
            calendar.add(5, -1);
        }
        for (int i = this.numberOfDaysPerWeek + (this.calendarView.getShowWeeks() ? 1 : 0); i < this.getChildren().size(); ++i) {
            Date currentDate = calendar.getTime();
            if (i % (this.numberOfDaysPerWeek + 1) == 0 && this.calendarView.getShowWeeks()) {
                Label label = (Label)this.getChildren().get(i);
                label.setText(Integer.toString(calendar.get(3)));
                continue;
            }
            Button control = (Button)this.getChildren().get(i);
            control.setText(Integer.toString(calendar.get(5)));
            control.setTooltip(new Tooltip(dateFormat.format(currentDate)));
            boolean disabled = this.calendarView.getDisabledWeekdays().contains((Object)calendar.get(7));
            for (Date disabledDate : this.calendarView.getDisabledDates()) {
                Calendar clone = (Calendar)calendar.clone();
                clone.setTime(disabledDate);
                if (calendar.get(1) != clone.get(1) || calendar.get(2) != clone.get(2) || calendar.get(5) != clone.get(5)) continue;
                disabled = true;
            }
            control.setDisable(disabled);
            control.getStyleClass().remove((Object)CSS_CALENDAR_DAY_CURRENT_MONTH);
            control.getStyleClass().remove((Object)CSS_CALENDAR_DAY_OTHER_MONTH);
            control.getStyleClass().remove((Object)CSS_CALENDAR_TODAY);
            if (calendar.get(2) == month) {
                control.getStyleClass().add((Object)CSS_CALENDAR_DAY_CURRENT_MONTH);
            } else {
                control.getStyleClass().add((Object)CSS_CALENDAR_DAY_OTHER_MONTH);
            }
            if (calendar.get(1) == todayYear && calendar.get(2) == todayMonth && calendar.get(5) == todayDay) {
                control.getStyleClass().add((Object)CSS_CALENDAR_TODAY);
            }
            control.setUserData((Object)calendar.getTime());
            calendar.add(5, 1);
        }
        calendar.setTime((Date)this.calendarView.calendarDate.get());
    }

    private void updateWeekNames() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols((Locale)this.calendarView.localeProperty().get());
        String[] weekDays = dateFormatSymbols.getShortWeekdays();
        for (int i = 1; i < weekDays.length; ++i) {
            String shortWeekDay = weekDays[i].substring(0, 2);
            int j = i - this.calendarView.getCalendar().getFirstDayOfWeek();
            if (j < 0) {
                j += weekDays.length - 1;
            }
            Label label = (Label)this.getChildren().get(j + (this.calendarView.getShowWeeks() ? 1 : 0));
            label.setText(shortWeekDay);
        }
        this.title.set((Object)this.getDateFormat("MMMM yyyy").format(this.calendarView.getCalendar().getTime()));
    }
}

