/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.calendar;

import com.itd.efiling.offline.common.calendar.CalendarView;
import java.util.Calendar;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;

final class MainNavigationPane
extends HBox {
    private static final String CSS_CALENDAR_NAVIGATION_ARROW = "calendar-navigation-arrow";
    private static final String CSS_CALENDAR_NAVIGATION_BUTTON = "calendar-navigation-button";
    private static final String CSS_CALENDAR_NAVIGATION_TITLE = "calendar-navigation-title";
    private static final String CSS_CALENDAR_HEADER = "calendar-header";
    private CalendarView calendarView;
    Button titleButton;

    public MainNavigationPane(final CalendarView calendarView) {
        this.calendarView = calendarView;
        this.titleButton = new Button();
        this.titleButton.getStyleClass().add((Object)CSS_CALENDAR_NAVIGATION_TITLE);
        this.titleButton.textProperty().bind((ObservableValue)calendarView.title);
        this.titleButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                switch (calendarView.currentlyViewing.get()) {
                    case 2: {
                        calendarView.currentlyViewing.set(1);
                        break;
                    }
                    case 1: {
                        calendarView.currentlyViewing.set(0);
                    }
                }
            }
        });
        this.titleButton.disableProperty().bind((ObservableValue)new BooleanBinding(){
            {
                super.bind(new Observable[]{calendarView.ongoingTransitions, calendarView.currentlyViewing});
            }

            protected boolean computeValue() {
                return calendarView.currentlyViewing.get() == 0 || calendarView.ongoingTransitions.get() > 0;
            }
        });
        HBox buttonBox = new HBox();
        buttonBox.getChildren().add((Object)this.titleButton);
        buttonBox.setAlignment(Pos.CENTER);
        HBox.setHgrow((Node)buttonBox, (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.getNavigationButton(-1));
        this.getChildren().add((Object)buttonBox);
        this.getChildren().add((Object)this.getNavigationButton(1));
        this.getStyleClass().add((Object)CSS_CALENDAR_HEADER);
    }

    private Button getNavigationButton(final int direction) {
        Button button = new Button();
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                Calendar calendar = MainNavigationPane.this.calendarView.getCalendar();
                switch (((MainNavigationPane)MainNavigationPane.this).calendarView.currentlyViewing.get()) {
                    case 2: {
                        calendar.add(2, 1 * direction);
                        break;
                    }
                    case 1: {
                        calendar.add(1, 1 * direction);
                        break;
                    }
                    case 0: {
                        calendar.add(1, 20 * direction);
                    }
                }
                ((MainNavigationPane)MainNavigationPane.this).calendarView.calendarDate.set((Object)calendar.getTime());
            }
        });
        Region rectangle = new Region();
        rectangle.setMaxWidth(Double.NEGATIVE_INFINITY);
        rectangle.setMaxHeight(Double.NEGATIVE_INFINITY);
        rectangle.setRotate(direction < 0 ? 90.0 : 270.0);
        rectangle.getStyleClass().add((Object)CSS_CALENDAR_NAVIGATION_ARROW);
        button.setGraphic((Node)rectangle);
        button.getStyleClass().add((Object)CSS_CALENDAR_NAVIGATION_BUTTON);
        return button;
    }
}

