/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.calendar;

import com.itd.efiling.offline.common.calendar.CalendarView;
import com.itd.efiling.offline.common.calendar.DatePane;
import java.util.Calendar;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

final class DecadesView
extends DatePane {
    private static final String CSS_CALENDAR_DECADES_VIEW = "calendar-decades-view";
    private static final int NUMBER_OF_DECADES = 2;

    public DecadesView(CalendarView calendarView) {
        super(calendarView);
        this.getStyleClass().add((Object)CSS_CALENDAR_DECADES_VIEW);
    }

    @Override
    protected void buildContent() {
        final Calendar calendar = this.calendarView.getCalendar();
        for (int i = 0; i < 20; ++i) {
            final Button button = new Button();
            button.setMaxWidth(Double.MAX_VALUE);
            button.setMaxHeight(Double.MAX_VALUE);
            GridPane.setVgrow((Node)button, (Priority)Priority.ALWAYS);
            GridPane.setHgrow((Node)button, (Priority)Priority.ALWAYS);
            button.getStyleClass().add((Object)"calendar-year-button");
            button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    if (DecadesView.this.calendarView.currentlyViewing.get() == 0) {
                        calendar.set(1, (Integer)button.getUserData());
                        DecadesView.this.calendarView.currentlyViewing.set(1);
                        DecadesView.this.calendarView.calendarDate.set((Object)calendar.getTime());
                    }
                }
            });
            int rowIndex = i % 5;
            int colIndex = (i - rowIndex) / 5;
            this.add((Node)button, rowIndex, colIndex);
        }
    }

    @Override
    protected void updateContent() {
        Calendar calendar = this.calendarView.getCalendar();
        int year = calendar.get(1);
        int a = year % 10;
        if (a < 5) {
            a += 10;
        }
        int startYear = year - a;
        for (int i = 0; i < 20; ++i) {
            int y = i + startYear;
            Button button = (Button)this.getChildren().get(i);
            button.setText(Integer.toString(y));
            button.setUserData((Object)y);
        }
        this.title.set((Object)String.format("%s - %s", startYear, startYear + 20 - 1));
    }
}

