/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.calendar;

import com.itd.efiling.offline.common.calendar.MainNavigationPane;
import com.itd.efiling.offline.common.calendar.MainStackPane;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class CalendarView
extends VBox {
    private static final String CSS_CALENDAR_FOOTER = "calendar-footer";
    private static final String CSS_CALENDAR = "calendar";
    private static final String CSS_CALENDAR_TODAY_BUTTON = "calendar-today-button";
    private HBox todayButtonBox;
    private ObjectProperty<Locale> locale = new SimpleObjectProperty();
    private ObjectProperty<Calendar> calendar = new SimpleObjectProperty();
    private ObservableList<Integer> disabledWeekdays = FXCollections.observableArrayList();
    private ObservableList<Date> disabledDates = FXCollections.observableArrayList();
    private ObjectProperty<Date> currentDate = new SimpleObjectProperty();
    private BooleanProperty showTodayButton = new SimpleBooleanProperty();
    private StringProperty todayButtonText = new SimpleStringProperty("Today");
    private BooleanProperty showWeeks = new SimpleBooleanProperty(false);
    MainNavigationPane mainNavigationPane;
    IntegerProperty ongoingTransitions = new SimpleIntegerProperty(0);
    ObjectProperty<Date> selectedDate = new SimpleObjectProperty();
    ObjectProperty<Date> calendarDate = new SimpleObjectProperty();
    IntegerProperty currentlyViewing = new SimpleIntegerProperty();
    StringProperty title = new SimpleStringProperty();

    public CalendarView() {
        this(Locale.getDefault());
    }

    public CalendarView(Locale locale) {
        this(locale, Calendar.getInstance(locale));
        this.locale.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                CalendarView.this.calendar.set((Object)Calendar.getInstance((Locale)CalendarView.this.localeProperty().get()));
            }
        });
    }

    public CalendarView(Locale locale, final Calendar calendar) {
        this.locale.set((Object)locale);
        this.calendar.set((Object)calendar);
        this.getStyleClass().add((Object)CSS_CALENDAR);
        this.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.currentlyViewing.set(2);
        this.calendarDate.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                calendar.setTime((Date)CalendarView.this.calendarDate.get());
            }
        });
        this.calendarDate.set((Object)new Date());
        this.currentDate.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                Date date = new Date();
                if (CalendarView.this.currentDate.get() != null) {
                    date = (Date)CalendarView.this.currentDate.get();
                }
                CalendarView.this.calendarDate.set((Object)date);
            }
        });
        MainStackPane mainStackPane = new MainStackPane(this);
        VBox.setVgrow((Node)mainStackPane, (Priority)Priority.ALWAYS);
        this.mainNavigationPane = new MainNavigationPane(this);
        this.todayButtonBox = new HBox();
        this.todayButtonBox.getStyleClass().add((Object)CSS_CALENDAR_FOOTER);
        Button todayButton = new Button();
        todayButton.textProperty().bind((ObservableValue)this.todayButtonText);
        todayButton.getStyleClass().add((Object)CSS_CALENDAR_TODAY_BUTTON);
        todayButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                Calendar calendar = (Calendar)CalendarView.this.calendarProperty().get();
                calendar.setTime(new Date());
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                CalendarView.this.selectedDate.set((Object)calendar.getTime());
            }
        });
        this.todayButtonBox.setAlignment(Pos.CENTER);
        this.todayButtonBox.getChildren().add((Object)todayButton);
        this.getChildren().addAll((Object[])new Node[]{this.mainNavigationPane, mainStackPane});
        this.showTodayButton.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                if (CalendarView.this.showTodayButton.get()) {
                    CalendarView.this.getChildren().add((Object)CalendarView.this.todayButtonBox);
                } else {
                    CalendarView.this.getChildren().remove((Object)CalendarView.this.todayButtonBox);
                }
            }
        });
        this.showTodayButton.set(true);
    }

    public ObjectProperty<Locale> localeProperty() {
        return this.locale;
    }

    public Locale getLocale() {
        return (Locale)this.locale.get();
    }

    public void setLocale(Locale locale) {
        this.locale.set((Object)locale);
    }

    public ObjectProperty<Calendar> calendarProperty() {
        return this.calendar;
    }

    public Calendar getCalendar() {
        return (Calendar)this.calendar.get();
    }

    public void setCalendar(Calendar calendar) {
        this.calendar.set((Object)calendar);
    }

    public ObservableList<Integer> getDisabledWeekdays() {
        return this.disabledWeekdays;
    }

    public ObservableList<Date> getDisabledDates() {
        return this.disabledDates;
    }

    public ReadOnlyObjectProperty<Date> selectedDateProperty() {
        return this.selectedDate;
    }

    public ObjectProperty<Date> currentDateProperty() {
        return this.currentDate;
    }

    public BooleanProperty showTodayButtonProperty() {
        return this.showTodayButton;
    }

    public boolean getShowTodayButton() {
        return this.showTodayButton.get();
    }

    public void setShowTodayButton(boolean showTodayButton) {
        this.showTodayButton.set(showTodayButton);
    }

    public StringProperty todayButtonTextProperty() {
        return this.todayButtonText;
    }

    public String getTodayButtonText() {
        return (String)this.todayButtonText.get();
    }

    public void setTodayButtonText(String todayButtonText) {
        this.todayButtonText.set((Object)todayButtonText);
    }

    public BooleanProperty showWeeksProperty() {
        return this.showWeeks;
    }

    public boolean getShowWeeks() {
        return this.showWeeks.get();
    }

    public void setShowWeeks(boolean showWeeks) {
        this.showWeeks.set(showWeeks);
    }
}

