/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.calendar;

import com.itd.efiling.offline.common.calendar.DatePane;
import java.util.Calendar;
import java.util.Date;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.TranslateTransition;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

final class AnimatedStackPane
extends StackPane {
    DatePane animatePane;
    DatePane actualPane;
    private static final Double SLIDE_ANIMATION_DURATION = 0.7;
    private ParallelTransition slideTransition;

    public AnimatedStackPane(final DatePane actualPane, DatePane animatePane) {
        this.animatePane = animatePane;
        animatePane.setVisible(false);
        this.actualPane = actualPane;
        this.getChildren().add((Object)animatePane);
        this.getChildren().add((Object)actualPane);
        this.getStyleClass().add((Object)"calendar-daypane");
        actualPane.calendarView.calendarDate.addListener((ChangeListener)new ChangeListener<Date>(){

            public void changed(ObservableValue<? extends Date> observableValue, Date oldDate, Date newDate) {
                Calendar calendar = actualPane.calendarView.getCalendar();
                calendar.setTime(oldDate);
                int oldYear = calendar.get(1);
                int oldMonth = calendar.get(2);
                calendar.setTime(newDate);
                int newYear = calendar.get(1);
                int newMonth = calendar.get(2);
                if (AnimatedStackPane.this.getWidth() > 0.0 && actualPane.calendarView.ongoingTransitions.get() == 0) {
                    if (newYear > oldYear || newYear == oldYear && newMonth > oldMonth) {
                        AnimatedStackPane.this.slideLeftRight(-1, oldDate);
                    } else if (newYear < oldYear || newYear == oldYear && newMonth < oldMonth) {
                        AnimatedStackPane.this.slideLeftRight(1, oldDate);
                    }
                }
            }
        });
    }

    private void slideLeftRight(int direction, Date oldDate) {
        if (this.slideTransition != null) {
            this.slideTransition.stop();
        }
        TranslateTransition transition1 = new TranslateTransition(Duration.seconds((double)SLIDE_ANIMATION_DURATION), (Node)this.animatePane);
        TranslateTransition transition2 = new TranslateTransition(Duration.seconds((double)SLIDE_ANIMATION_DURATION), (Node)this.actualPane);
        this.animatePane.setVisible(true);
        this.animatePane.setDate(oldDate);
        this.setClip((Node)new Rectangle(this.animatePane.getBoundsInLocal().getWidth(), this.animatePane.getBoundsInLocal().getHeight()));
        transition1.setFromX((double)(-direction * 1));
        transition1.setToX(this.getLayoutBounds().getWidth() * (double)direction + (double)(-direction * 1));
        transition2.setFromX(-this.getBoundsInParent().getWidth() * (double)direction);
        transition2.setToX(0.0);
        this.slideTransition = new ParallelTransition();
        this.slideTransition.getChildren().addAll((Object[])new Animation[]{transition1, transition2});
        this.slideTransition.setInterpolator(Interpolator.EASE_OUT);
        this.slideTransition.play();
        this.slideTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                AnimatedStackPane.this.animatePane.setVisible(false);
                AnimatedStackPane.this.setClip(null);
            }
        });
    }
}

