/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.javafx.ui.wrappers;

import com.itd.efiling.offline.common.config.ComboBoxOptionsCacher;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.util.DataTransporter;
import com.itd.efiling.offline.common.util.DateUtil;
import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import com.itd.efiling.offline.javafx.ui.components.ValTableColumn;
import java.util.Date;
import java.util.logging.Level;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class TabPropertyValueFactory
implements Callback<TableColumn.CellDataFeatures<Object, Object>, ObservableValue<Object>> {
    private final String target;
    private final ValTableColumn tableColumn;

    public TabPropertyValueFactory(String target, ValTableColumn tableColumn) {
        this.target = target;
        this.tableColumn = tableColumn;
    }

    public ObservableValue<Object> call(TableColumn.CellDataFeatures<Object, Object> param) {
        return this.getCellDataReflectively(param.getValue());
    }

    private ObservableValue<Object> getCellDataReflectively(Object rowData) {
        String finalTarget = this.target;
        try {
            if ("slNo".equals(this.target)) {
                LoggerManager.LOG.fine("rowData : " + rowData);
                return new ReadOnlyObjectWrapper((Object)(this.tableColumn.getTableView().getItems().indexOf(rowData) + 1));
            }
            if (this.target.startsWith("dropDown-")) {
                finalTarget = this.target.substring(9);
            }
            Object finalValue = ValidationUtil.nvl(DataTransporter.getObjectFromPath(rowData, finalTarget, false), "");
            if (this.target.startsWith("dropDown-")) {
                String key = finalValue.toString();
                String opt = ComboBoxOptionsCacher.getValue(finalTarget, key);
                LoggerManager.LOG.fine("finalTarget : " + finalTarget + " opt " + opt);
                return new ReadOnlyObjectWrapper((Object)opt);
            }
            if (finalValue instanceof Date && finalValue != null) {
                String date = DateUtil.toString(finalValue);
                return new ReadOnlyObjectWrapper((Object)date);
            }
            LoggerManager.LOG.fine("finalTarget : " + finalTarget + " finalValue " + finalValue);
            return new ReadOnlyObjectWrapper(finalValue);
        }
        catch (Throwable e) {
            LoggerManager.LOG.warning("finalTarget : " + finalTarget + " rowData " + rowData);
            LoggerManager.LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return null;
        }
    }

    public String getTarget() {
        return this.target;
    }
}

