/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.javafx.ui.components;

import com.itd.efiling.offline.common.util.CommonUtil;
import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import com.itd.efiling.offline.javafx.ui.components.ValidationAware;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextField;

public class ValDateField
extends TextField
implements ValidationAware {
    private final StringProperty target = new SimpleStringProperty();
    private final IntegerProperty maxLength = new SimpleIntegerProperty(250);
    private final BooleanProperty required = new SimpleBooleanProperty(false);
    private final StringProperty requiredMsg = new SimpleStringProperty();

    public ValDateField() {
        this.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String t, String t1) {
                ValDateField.this.setStyle("");
                if (t1.length() > 10) {
                    ValDateField.this.setText(t);
                }
            }
        });
    }

    public void replaceText(int start, int end, String text) {
        if (this.matchTest(text)) {
            super.replaceText(start, end, text);
        }
    }

    public void replaceSelection(String text) {
        if (this.matchTest(text = CommonUtil.getPrintableChar(text))) {
            super.replaceSelection(text);
        }
    }

    private boolean matchTest(String text) {
        return text.isEmpty() || text.matches("[0-9/]") && this.getText().length() < 10;
    }

    @Override
    public String getTarget() {
        return this.target.getValue();
    }

    @Override
    public void setTarget(String target) {
        this.target.setValue(target);
        this.addFieldForValidation(target);
    }

    @Override
    public void addFieldForValidation(String target) {
        ValidationUtil.addFieldForValidation(target, this);
    }

    public StringProperty targetProperty() {
        return this.target;
    }

    @Override
    public int getMaxLength() {
        return this.maxLength.getValue();
    }

    public void setMaxLength(int maxAllowedLength) {
        this.maxLength.setValue((Number)maxAllowedLength);
    }

    public IntegerProperty maxLengthProperty() {
        return this.maxLength;
    }

    public boolean getRequired() {
        return this.required.getValue();
    }

    public void setRequired(boolean required) {
        this.required.setValue(Boolean.valueOf(required));
    }

    public BooleanProperty requiredProperty() {
        return this.required;
    }

    public String getRequiredMsg() {
        return this.requiredMsg.getValue();
    }

    public void setRequiredMsg(String requiredMsg) {
        this.requiredMsg.setValue(requiredMsg);
    }

    public StringProperty requiredMsgProperty() {
        return this.requiredMsg;
    }

    @Override
    public void setData(Object src) {
        this.setText((String)src);
    }

    @Override
    public Object getData() {
        return this.getText();
    }
}

