/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.javafx.ui.components;

import com.itd.efiling.offline.common.dialog.MessageDialogCtrl;
import com.itd.efiling.offline.common.util.CommonUtil;
import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import com.itd.efiling.offline.javafx.ui.components.ValTextField;
import java.math.BigInteger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Pos;

public class ValBigIntegerField
extends ValTextField {
    private final BooleanProperty negative = new SimpleBooleanProperty(false);

    public ValBigIntegerField() {
        this.setAlignment(Pos.CENTER_RIGHT);
    }

    public Boolean getNegative() {
        return this.negative.getValue();
    }

    public void setNegative(Boolean negative) {
        this.negative.setValue(negative);
    }

    public BooleanProperty negativeProperty() {
        return this.negative;
    }

    @Override
    public Object getData() {
        try {
            if (!ValidationUtil.isStringEmpty(super.getText())) {
                return new BigInteger(super.getText());
            }
        }
        catch (Exception e) {
            MessageDialogCtrl.displayErrorDialog("Invalid characters in the input");
        }
        return null;
    }

    @Override
    public void replaceText(int start, int end, String text) {
        if (this.matchTest(text)) {
            super.replaceText(start, end, text);
        }
    }

    @Override
    public void replaceSelection(String text) {
        if (this.matchTest(text = CommonUtil.getPrintableChar(text))) {
            super.replaceSelection(text);
        }
    }

    @Override
    public boolean matchTest(String text) {
        if (this.negative.getValue().booleanValue()) {
            return ValidationUtil.isStringEmpty(text) && text.length() == 0 || text.matches("[\\-0-9]*") && (this.getText() == null || this.getText().length() < this.getMaxLength());
        }
        return ValidationUtil.isStringEmpty(text) && text.length() == 0 || text.matches("[0-9]*") && (this.getText() == null || this.getText().length() < this.getMaxLength());
    }
}

