/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.javafx.ui.components;

import com.itd.efiling.offline.common.config.ErrorMessages;
import com.itd.efiling.offline.common.csv.jaxb.beans.ImportCsvCacher;
import com.itd.efiling.offline.common.csv.jaxb.beans.ImportCsvMapping;
import com.itd.efiling.offline.common.csv.util.CSVFormat;
import com.itd.efiling.offline.common.csv.util.CSVParser;
import com.itd.efiling.offline.common.csv.util.CSVRecord;
import com.itd.efiling.offline.common.csv.util.QuoteMode;
import com.itd.efiling.offline.common.dialog.MessageDialogBuilder;
import com.itd.efiling.offline.common.dialog.MessageDialogCtrl;
import com.itd.efiling.offline.common.exception.CsvImportValidationException;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.onchange.util.OnChangeCommonUtil;
import com.itd.efiling.offline.common.player.ctrl.Form;
import com.itd.efiling.offline.common.util.CommonUtil;
import com.itd.efiling.offline.common.util.DataTransporter;
import com.itd.efiling.offline.common.util.JfxCommonUtil;
import com.itd.efiling.offline.common.validation.cachers.FieldValidtionCacher;
import com.itd.efiling.offline.common.validation.jaxb.beans.FieldValidatorRoot;
import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import com.itd.efiling.offline.common.validation.validators.ValidatorInteface;
import com.itd.efiling.offline.javafx.ui.components.ValRowEditorPane;
import com.itd.efiling.offline.javafx.ui.components.ValTableView;
import com.itd.efiling.offline.javafx.ui.components.ValTextField;
import java.io.File;
import java.io.FileReader;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;

public abstract class TableViewController<S> {
    protected S type;
    @FXML
    protected ValTextField uniqueIdNumber;
    @FXML
    protected ValTableView<S> tableView;
    @FXML
    protected ValRowEditorPane<S> rowEditorPane;

    public abstract S getNewBean();

    public TableViewController() {
        ValidationUtil.ALL_TVC.put(this.getClass().toString(), this);
    }

    public Object getRootObject() {
        return Form.getForm();
    }

    @FXML
    public void addRow(Event e) {
        this.addRow(true);
    }

    private void addRow(boolean addRow) {
        LoggerManager.LOG.info("Inside addRow ");
        if (this.rowEditorPane.getRowFor() == null) {
            this.setRowFor();
        }
        if (addRow) {
            this.type = this.getNewBean();
        }
        if (this.uniqueIdNumber != null) {
            this.uniqueIdNumber.setData(null);
            this.uniqueIdNumber.setEditable(true);
            this.uniqueIdNumber.setDisable(false);
        }
        this.rowEditorPane.setVisible(true);
        this.rowEditorPane.setOperation(1);
    }

    @FXML
    public void copyRow(Event e) {
        LoggerManager.LOG.info("Inside copyRow ");
        S item = this.getSelectedItem();
        LoggerManager.LOG.info("Before clone : " + item);
        if (item != null) {
            this.type = this.getNewBean();
            DataTransporter.completeCopyBeanExcludeList(item, this.type);
            this.addRow(false);
        }
    }

    @FXML
    public void editRow(Event e) {
        LoggerManager.LOG.info("Inside editRow ");
        S item = this.getSelectedItem();
        LoggerManager.LOG.info("Before clone : " + item);
        if (item != null) {
            this.type = this.getNewBean();
            DataTransporter.completeCopyBean(item, this.type);
            if (this.uniqueIdNumber != null) {
                this.uniqueIdNumber.setEditable(false);
                this.uniqueIdNumber.setDisable(true);
            }
            this.rowEditorPane.setVisible(true);
            this.rowEditorPane.setOperation(2);
        }
    }

    @FXML
    public void deleteRow(Event e) {
        LoggerManager.LOG.info("Inside deleteRow ");
        S item = this.getSelectedItem();
        if (item != null) {
            this.tableView.getItems().remove(item);
            if (!ValidationUtil.isStringEmpty(this.tableView.getTarget())) {
                List targetList = (List)DataTransporter.getObjectFromPath(this.getRootObject(), this.tableView.getTarget());
                targetList.remove(item);
            }
            this.rowEditorPane.callOnChangeUtilOnSave();
        }
    }

    @FXML
    public void saveDtl(Event e) {
        try {
            LoggerManager.LOG.info("Inside saveRow()... : " + this.rowEditorPane.getOperation() + " ::  " + this.type);
            this.saveDtl();
        }
        catch (Exception ex) {
            LoggerManager.LOG.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }

    @FXML
    public void cancel(Event e) {
        LoggerManager.LOG.info("Inside cancel ");
        this.type = this.getNewBean();
        this.rowEditorPane.setVisible(false);
        this.rowEditorPane.setOperation(1);
        JfxCommonUtil.clearVrepFieldErrors(this.rowEditorPane);
    }

    public void initOnLoad(Form src) throws InstantiationException, IllegalAccessException {
        Object objList;
        if (this.rowEditorPane == null) {
            this.setRowFor();
        }
        if ((objList = DataTransporter.getObjectFromPath((Object)src, this.tableView.getTarget(), false)) != null) {
            List list = (List)objList;
            this.tableView.getItems().addAll((Collection)list);
        }
    }

    public void setRowFor() {
        this.rowEditorPane.setRowFor(this.tableView);
    }

    public S getType() {
        if (this.type == null) {
            return this.getNewBean();
        }
        return this.type;
    }

    public void setType(S type) {
        this.type = type;
    }

    public ValTableView<S> getTableView() {
        return this.tableView;
    }

    public void setTableView(ValTableView<S> tableView) {
        this.tableView = tableView;
    }

    public ValRowEditorPane<S> getRowEditorPane() {
        return this.rowEditorPane;
    }

    public void setRowEditorPane(ValRowEditorPane<S> rowEditorPane) {
        this.rowEditorPane = rowEditorPane;
    }

    protected S getSelectedItem() {
        Object selectedItem = this.tableView.getSelectionModel().getSelectedItem();
        LoggerManager.LOG.info("Before selectedItem : " + selectedItem);
        if (selectedItem != null) {
            return (S)selectedItem;
        }
        MessageDialogBuilder mb = MessageDialogBuilder.info();
        mb.message("Please select a row.");
        mb.show(this.tableView.getScene().getWindow());
        return null;
    }

    protected void saveDtl() throws InstantiationException, IllegalAccessException {
        this.saveDtl(true);
    }

    protected void saveDtl(boolean saveInTargetList) throws InstantiationException, IllegalAccessException {
        if (!ValidationUtil.validateListOnVrepCtrl(this.rowEditorPane.getTarget())) {
            return;
        }
        if (this.rowEditorPane.validateBeforeSave()) {
            List targetList = (List)DataTransporter.getObjectFromPath(this.getRootObject(), this.tableView.getTarget());
            if (this.rowEditorPane.getOperation() == 1) {
                int index = this.tableView.getItems().indexOf(this.type);
                LoggerManager.LOG.info("ADD_OPERATION Item index : " + index);
                if (index != -1) {
                    MessageDialogBuilder messageDialogBuilder = MessageDialogBuilder.error();
                    messageDialogBuilder.message(ErrorMessages.getStringValue(this.tableView.getTarget() + ".duplicate"));
                    messageDialogBuilder.show(this.tableView.getScene().getWindow());
                    return;
                }
                this.tableView.getItems().add(this.type);
                if (saveInTargetList) {
                    targetList.add(this.type);
                }
            } else if (this.rowEditorPane.getOperation() == 2) {
                Object selectedItem = this.tableView.getSelectionModel().getSelectedItem();
                int tableViewIndex = this.tableView.getItems().indexOf(selectedItem);
                LoggerManager.LOG.info("selectedItem : " + selectedItem);
                LoggerManager.LOG.info("type : " + this.type);
                if (saveInTargetList) {
                    int targetListIndex = targetList.indexOf(selectedItem);
                    targetList.remove(targetListIndex);
                    targetList.add(targetListIndex, this.type);
                }
                this.tableView.getItems().remove(tableViewIndex);
                this.tableView.getItems().add(tableViewIndex, this.type);
            }
            ((TableColumn)this.tableView.getColumns().get(0)).setVisible(false);
            ((TableColumn)this.tableView.getColumns().get(0)).setVisible(true);
            this.rowEditorPane.callOnChangeUtilOnSave();
            this.rowEditorPane.setVisible(false);
            this.rowEditorPane.setOperation(1);
            this.type = this.type.getClass().newInstance();
            ValidatorInteface.clearFieldErrorToValidation(this.tableView.getTarget());
        }
    }

    @FXML
    public void importCsv(Event event) throws Exception {
        LoggerManager.LOG.fine("Inside importCsv ");
        try {
            LinkedHashSet<Object> uniqueIds = new LinkedHashSet<Object>();
            File file = JfxCommonUtil.openFileDialog(".csv", "Open");
            if (file != null) {
                FileReader in = new FileReader(file);
                CSVParser records = CSVFormat.EXCEL.withHeader(new String[0]).withQuoteMode(QuoteMode.ALL).parse(in);
                LoggerManager.LOG.info("records " + records);
                List<ImportCsvMapping> importCsvMappings = ImportCsvCacher.getImportCsvMappings(this.tableView.getTarget());
                String uniqueIdentifier = ImportCsvCacher.getUniqueIdentifier(this.tableView.getTarget());
                LoggerManager.LOG.info("importCsvMappings " + importCsvMappings.size());
                Map<String, Integer> headerMap = records.getHeaderMap();
                int indx = 0;
                for (ImportCsvMapping importCsvMapping : importCsvMappings) {
                    if (headerMap.get(importCsvMapping.getHeaderName()) != null) {
                        int headerIndx = headerMap.get(importCsvMapping.getHeaderName());
                        if (indx != headerIndx) {
                            MessageDialogCtrl.displayErrorDialog("Incorrect CSV file");
                            return;
                        }
                    } else {
                        MessageDialogCtrl.displayErrorDialog("Incorrect CSV file");
                        return;
                    }
                    ++indx;
                }
                int index = 1;
                LinkedList<S> list = new LinkedList<S>();
                LoggerManager.LOG.fine("Before Loop ");
                for (CSVRecord record : records) {
                    this.type = this.getNewBean();
                    for (ImportCsvMapping importCsvMapping : importCsvMappings) {
                        Object fieldValueToSet = CommonUtil.getTypedValue(record.get(importCsvMapping.getColNum()), importCsvMapping.getType(), index, importCsvMapping.getHeaderName());
                        DataTransporter.transferDataToBean(this.type, importCsvMapping.getFieldName(), fieldValueToSet, false);
                        String target = importCsvMapping.getTarget();
                        LoggerManager.LOG.fine("target {}" + target);
                        OnChangeCommonUtil.executeOnChangeMethod(target, fieldValueToSet);
                        List<FieldValidatorRoot> fieldValidators = FieldValidtionCacher.getValidationImplementor(target);
                        if (fieldValidators == null) continue;
                        for (FieldValidatorRoot fvr : fieldValidators) {
                            ValidatorInteface validator = fvr.getValidator();
                            try {
                                validator.onCsvImportValidateCtrl(fieldValueToSet, target);
                            }
                            catch (CsvImportValidationException e) {
                                this.type = this.getNewBean();
                                e.printStackTrace();
                                e.setDialogErrorMessage(index, importCsvMapping.getHeaderName());
                                throw e;
                            }
                        }
                    }
                    if (uniqueIdentifier != null) {
                        Object uniqueIdentifierValue = DataTransporter.getObjectFromPath(this.type, uniqueIdentifier, false);
                        if (uniqueIds.contains(uniqueIdentifierValue)) {
                            MessageDialogCtrl.displayErrorDialog(ErrorMessages.getError("duplicate.uniqueIds"));
                            return;
                        }
                        uniqueIds.add(uniqueIdentifierValue);
                    }
                    list.add(this.type);
                    ++index;
                }
                LoggerManager.LOG.fine("After Loop ");
                List targetList = (List)DataTransporter.getObjectFromPath((Object)Form.getForm(), this.tableView.getTarget());
                targetList.addAll(list);
                this.tableView.getItems().addAll(list);
                LoggerManager.LOG.fine("After importCsv ");
                MessageDialogCtrl.displayInfoDialog("Success", " Total Number of rows imported " + list.size());
            }
        }
        catch (CsvImportValidationException e) {
            MessageDialogCtrl.displayErrorDialog(e.getDialogErrorMessage());
        }
        catch (Throwable e) {
            LoggerManager.LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
            MessageDialogCtrl.displayErrorDialog("Invalid File");
        }
    }
}

