/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.javafx.ui.components;

import com.itd.efiling.offline.common.dialog.MessageDialogBuilder;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.player.ctrl.Form;
import com.itd.efiling.offline.common.util.DataTransporter;
import com.itd.efiling.offline.common.util.JfxCommonUtil;
import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import com.itd.efiling.offline.javafx.ui.components.ValRowEditorPane;
import com.itd.efiling.offline.javafx.ui.components.ValTableView;
import com.itd.efiling.offline.javafx.ui.components.ValidationAware;
import java.util.Collection;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.HBox;

public abstract class TableViewAddController<T, P> {
    protected P parent;
    protected T type;
    protected ValRowEditorPane<P> valRowEditorPane;
    @FXML
    protected ValTableView<T> tableView;
    @FXML
    protected HBox fieldsHbox;
    @FXML
    protected TitledPane titledPane;

    public abstract String getPath();

    public abstract T getNewBean();

    public abstract void initOnLoadRecrusively(Form var1) throws Exception;

    public abstract String getRootTarget();

    public TableViewAddController() {
        ValidationUtil.ALL_TVAC.put(this.getClass().toString(), this);
    }

    public boolean validateBeforeSave() {
        ObservableList nodes = this.fieldsHbox.getChildrenUnmodifiable();
        LoggerManager.LOG.info(" Before validateBeforeSave ");
        return ValidationUtil.validateBeforeSave((List<Node>)nodes);
    }

    private void clearFields() {
        ObservableList nodes = this.fieldsHbox.getChildrenUnmodifiable();
        for (Node node : nodes) {
            if (!(node instanceof ValidationAware)) continue;
            ValidationAware validationAware = (ValidationAware)node;
            validationAware.setData(null);
        }
    }

    public void addDtlsCtrl(ValRowEditorPane<P> valRowEditorPane, P parent) {
        LoggerManager.LOG.info("Inside addDtlsCtrl ");
        this.tableView.getItems().clear();
        List targetList = (List)DataTransporter.getObjectFromPath(parent, this.getPath());
        this.tableView.getItems().addAll((Collection)targetList);
        this.titledPane.setVisible(true);
        this.parent = parent;
        this.valRowEditorPane = valRowEditorPane;
        valRowEditorPane.setVisible(false);
        this.type = this.getNewBean();
        JfxCommonUtil.ctrlHome();
    }

    @FXML
    protected void addDtl(ActionEvent event) throws InstantiationException, IllegalAccessException {
        if (this.validateBeforeSave()) {
            LoggerManager.LOG.info("Inside addDtl ");
            ObservableList data = this.tableView.getItems();
            LoggerManager.LOG.info("type :   " + this.type);
            data.add(this.type);
            this.type = this.getNewBean();
            this.clearFields();
        }
    }

    @FXML
    public void deleteDtl(Event e) {
        LoggerManager.LOG.info("Inside deleteRow ");
        T item = this.getSelectedItem();
        if (item != null) {
            this.tableView.getItems().remove(item);
            List targetList = (List)DataTransporter.getObjectFromPath(this.parent, this.getPath());
            targetList.remove(item);
        }
    }

    @FXML
    protected void saveDtl(ActionEvent event) {
        LoggerManager.LOG.info("Inside saveDtl ");
        this.titledPane.setVisible(false);
        this.valRowEditorPane.setVisible(true);
        List targetList = (List)DataTransporter.getObjectFromPath(this.parent, this.getPath());
        ObservableList data = this.tableView.getItems();
        targetList.clear();
        targetList.addAll(data);
        LoggerManager.LOG.info("After saveDtl ");
        this.clearFields();
    }

    @FXML
    public void cancelDtl(Event e) {
        LoggerManager.LOG.info("Inside cancelDtl ");
        JfxCommonUtil.ctrlHome();
        this.titledPane.setVisible(false);
        this.valRowEditorPane.setVisible(true);
        this.clearFields();
    }

    public P getParent() {
        return this.parent;
    }

    public void setParent(P parent) {
        this.parent = parent;
    }

    public T getType() {
        return this.type;
    }

    public void setType(T type) {
        this.type = type;
    }

    public ValRowEditorPane<P> getValRowEditorPane() {
        return this.valRowEditorPane;
    }

    public void setValRowEditorPane(ValRowEditorPane<P> valRowEditorPane) {
        this.valRowEditorPane = valRowEditorPane;
    }

    public ValTableView<T> getTableView() {
        return this.tableView;
    }

    public void setTableView(ValTableView<T> tableView) {
        this.tableView = tableView;
    }

    public TitledPane getTitledPane() {
        return this.titledPane;
    }

    public void setTitledPane(TitledPane titledPane) {
        this.titledPane = titledPane;
    }

    public T getBean() {
        return this.type;
    }

    public void setBean(T s) {
        this.type = s;
    }

    protected T getSelectedItem() {
        Object selectedItem = this.tableView.getSelectionModel().getSelectedItem();
        LoggerManager.LOG.info("Before selectedItem : " + selectedItem);
        if (selectedItem != null) {
            return (T)selectedItem;
        }
        MessageDialogBuilder mb = MessageDialogBuilder.info();
        mb.message("Please select a row.");
        mb.show(this.tableView.getScene().getWindow());
        return null;
    }
}

