/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.form15ca.onchange.util;

import com.itd.efiling.offline.common.config.ComboBoxOptionsCacher;
import com.itd.efiling.offline.common.config.Configs;
import com.itd.efiling.offline.common.dialog.MessageDialog;
import com.itd.efiling.offline.common.dialog.MessageDialogCtrl;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.onchange.util.OnChangeCommonUtil;
import com.itd.efiling.offline.common.player.ctrl.Form;
import com.itd.efiling.offline.common.reference.holders.RefHolders;
import com.itd.efiling.offline.common.util.DataTransporter;
import com.itd.efiling.offline.common.util.JfxCommonUtil;
import com.itd.efiling.offline.common.util.XmlUtil;
import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import com.itd.efiling.offline.common.validation.validators.ValidatorInteface;
import com.itd.efiling.offline.form15ca.model.FORM15CB;
import com.itd.efiling.offline.form15ca.model.Form15CA;
import com.itd.efiling.offline.javafx.ui.components.ValidationAware;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

public class OnChangeUtil {
    static String remitterCountry = "form15ca.remitterDetls.remitterAddrs.country";
    static String accntCountry = "form15ca.acctntDetls.acctntAddrs.country";
    static String remitterState = "form15ca.remitterDetls.remitterAddrs.state";
    static String accntState = "form15ca.acctntDetls.acctntAddrs.state";
    static String remitterPincode = "form15ca.remitterDetls.remitterAddrs.pincode";
    static String remitteePincode = "form15ca.remitteeDetls.remitteeAddrs.pincode";
    static String accntPincode = "form15ca.acctntDetls.acctntAddrs.pincode";

    private OnChangeUtil() {
    }

    public static void onChangeOfPartType(ValidationAware field) {
        OnChangeUtil.onChangeOfPartType(field.getData().toString(), false);
    }

    public static void onChnageSalutation(ValidationAware field) {
        String salutation = field.getData().equals("1") ? "I" : "We";
        OnChangeCommonUtil.setElementValueByTargetName("form15ca.declaration.iWe1", salutation);
        OnChangeCommonUtil.setElementValueByTargetName("form15ca.declaration.iWe2", salutation);
        if (salutation.equals("I")) {
            OnChangeCommonUtil.setElementValueByTargetName("form15ca.declaration.iWe3", "my");
            OnChangeCommonUtil.setElementValueByTargetName("form15ca.declaration.iWe6", "my");
        } else {
            OnChangeCommonUtil.setElementValueByTargetName("form15ca.declaration.iWe3", "our");
            OnChangeCommonUtil.setElementValueByTargetName("form15ca.declaration.iWe6", "our");
        }
        OnChangeCommonUtil.setElementValueByTargetName("form15ca.declaration.iWe4", salutation);
        OnChangeCommonUtil.setElementValueByTargetName("form15ca.declaration.iWe5", salutation);
    }

    public static void onChnageDesgnation(ValidationAware field) {
        OnChangeCommonUtil.setElementValueByTargetName("form15ca.declaration.verDesignation1", field.getData());
    }

    public static void onChnageNatOfRemittance(ValidationAware field) {
        ValidationAware natureRemCode = ValidationUtil.ALL_FIELDS_MAP.get("form15ca.remittanceDetls.natureRemCode");
        if (field.getData().toString().equals("16.99")) {
            natureRemCode.setDisable(false);
        } else {
            natureRemCode.setDisable(true);
            natureRemCode.setData(null);
        }
    }

    public static void onChangeRbiPurCategory(ValidationAware field) {
        String value = field.getData().toString();
        OnChangeUtil.rbiPurposeCodeChange(value, null);
    }

    public static void rbiPurposeCodeChange(String value, String setValue) {
        ValidationAware revPurCode = ValidationUtil.ALL_FIELDS_MAP.get("form15ca.remittanceDetls.revPurCode");
        if (value.equals("RB-0.1")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.captialAcc");
        } else if (value.equals("RB-0.2")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.foreignDirectInvest");
        } else if (value.equals("RB-0.3")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.foreignPortInvest");
        } else if (value.equals("RB-0.4")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.extCommBorrowing");
        } else if (value.equals("RB-0.5")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.shortTermLoan");
        } else if (value.equals("RB-0.6")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.bankCapital");
        } else if (value.equals("RB-0.7")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.finDerivativesSer");
        } else if (value.equals("RB-0.8")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.extAssistance");
        } else if (value.equals("RB-1.1")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.imports");
        } else if (value.equals("RB-2.1")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.transport");
        } else if (value.equals("RB-3.1")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.travel");
        } else if (value.equals("RB-5.1")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.constructionSer");
        } else if (value.equals("RB-6.1")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.insPensionSer");
        } else if (value.equals("RB-7.1")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.financialServices");
        } else if (value.equals("RB-8.1")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.compInfoSer");
        } else if (value.equals("RB-9.1")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.chargesForIntellProperty");
        } else if (value.equals("RB-10.1")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.otherBussSer");
        } else if (value.equals("RB-11.1")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.personalSer");
        } else if (value.equals("RB-12.1")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.govtNotIncluding");
        } else if (value.equals("RB-13.1")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.secIncome");
        } else if (value.equals("RB-14.1")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.priIncome");
        } else if (value.equals("RB-15.1")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.others");
        } else if (value.equals("RB-16.1")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.maintainanceSer");
        } else if (value.equals("RB-17.1")) {
            revPurCode.setTarget("form15ca.commonForm.rbiPurCode.manufacturingSer");
        }
        if (setValue != null) {
            OnChangeCommonUtil.setElementValueByTargetName(revPurCode.getTarget(), setValue);
            OnChangeCommonUtil.setElementValueByTargetName("form15ca.remittanceDetls.revPurCode", setValue);
        }
    }

    public static void onChangeRbiPurCode(ValidationAware field) {
        String value = field.getData().toString();
        OnChangeCommonUtil.setElementValueByTargetName("form15ca.remittanceDetls.revPurCode", value);
    }

    public static void onChangeNameOfBank(ValidationAware field) {
        ValidationAware nameBankDesc = ValidationUtil.ALL_FIELDS_MAP.get("form15ca.remittanceDetls.nameBankDesc");
        if (!field.getData().equals("999")) {
            nameBankDesc.setDisable(true);
            OnChangeCommonUtil.setElementValueByTargetName(nameBankDesc.getTarget(), null);
        } else {
            nameBankDesc.setDisable(false);
        }
    }

    public static void onChangeCurrencyCode(ValidationAware field) {
        ValidationAware remittanceCurrSecbDesc = ValidationUtil.ALL_FIELDS_MAP.get("form15ca.remittanceDetls.currencySecbDesc");
        if (!field.getData().equals("99")) {
            remittanceCurrSecbDesc.setDisable(true);
            OnChangeCommonUtil.setElementValueByTargetName(remittanceCurrSecbDesc.getTarget(), null);
        } else {
            remittanceCurrSecbDesc.setDisable(false);
        }
    }

    public static void onChnageName(ValidationAware field) {
        OnChangeCommonUtil.setElementValueByTargetName("form15ca.declaration.styledName1", field.getData());
    }

    private static void loadPart(String fxmlPath, String tabName) {
        try {
            Tab tab = new Tab();
            tab.setContent((Node)FXMLLoader.load((URL)OnChangeUtil.class.getResource(fxmlPath)));
            tab.setText(tabName);
            Form.getForm().getTabPane().getTabs().add((Object)tab);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void onChangeState(ValidationAware field) {
        String dest = null;
        String pincode = null;
        if (field.getTarget().equals(remitterState)) {
            dest = remitterCountry;
            pincode = remitterPincode;
        } else if (field.getTarget().equals(accntState)) {
            dest = accntCountry;
            pincode = accntPincode;
        }
        OnChangeUtil.onChangeState(field, dest, pincode);
    }

    public static void onChangeCountry(ValidationAware field) {
        String dest = "";
        if (field.getTarget().equals(remitterCountry)) {
            dest = remitterState;
        } else if (field.getTarget().equals(accntCountry)) {
            dest = accntState;
        }
        OnChangeUtil.onChangeCountry(field, dest);
    }

    public static void onChangeState(ValidationAware field, String country, String pincode) {
        if (field.getData().equals("99") || field.getData().equals("-1")) {
            OnChangeCommonUtil.setElementValueByTargetName(country, "-1");
            OnChangeCommonUtil.setElementValueByTargetName(pincode, "999999");
        } else {
            OnChangeCommonUtil.setElementValueByTargetName(country, "91");
            OnChangeCommonUtil.setElementValueByTargetName(pincode, "");
        }
    }

    public static void onChangeCountry(ValidationAware field, String dest) {
        if (field.getData().equals("91") || field.getData().equals("-1")) {
            OnChangeCommonUtil.setElementValueByTargetName(dest, "-1");
        } else {
            OnChangeCommonUtil.setElementValueByTargetName(dest, "99");
        }
    }

    public static void onChangeCountryRemMade(ValidationAware field) {
        ValidationAware remittanceCountryRemMadeDesc = ValidationUtil.ALL_FIELDS_MAP.get("form15ca.remittanceDetls.countryRemMadeSecbDesc");
        if (field.getData().equals("9999")) {
            remittanceCountryRemMadeDesc.setDisable(false);
        } else {
            remittanceCountryRemMadeDesc.setDisable(true);
            OnChangeCommonUtil.setElementValueByTargetName(remittanceCountryRemMadeDesc.getTarget(), null);
        }
    }

    public static void onChangeCountryRemMadeRemitee(ValidationAware field) {
        ValidationAware remitteeCountryRemMadeDesc = ValidationUtil.ALL_FIELDS_MAP.get("form15ca.remitteeDetls.countryRemMadeDesc");
        if (field.getData().equals("9999")) {
            remitteeCountryRemMadeDesc.setDisable(false);
        } else {
            remitteeCountryRemMadeDesc.setDisable(true);
            OnChangeCommonUtil.setElementValueByTargetName(remitteeCountryRemMadeDesc.getTarget(), null);
        }
    }

    public static void onChangeOrderAoFlg(ValidationAware field) {
        ValidationAware certSection = ValidationUtil.ALL_FIELDS_MAP.get("form15ca.aoOrderDetls.certSection");
        ValidationAware nameAo = ValidationUtil.ALL_FIELDS_MAP.get("form15ca.aoOrderDetls.nameAo");
        ValidationAware desgAo = ValidationUtil.ALL_FIELDS_MAP.get("form15ca.aoOrderDetls.designationAo");
        ValidationAware orderDateAo = ValidationUtil.ALL_FIELDS_MAP.get("form15ca.aoOrderDetls.orderDateAo");
        ValidationAware orderNumAo = ValidationUtil.ALL_FIELDS_MAP.get("form15ca.aoOrderDetls.orderNumAo");
        if (!field.getData().equals("Y")) {
            certSection.setDisable(true);
            nameAo.setDisable(true);
            desgAo.setDisable(true);
            orderNumAo.setDisable(true);
            orderDateAo.setDisable(false);
            OnChangeCommonUtil.setElementValueByTargetName(orderDateAo.getTarget(), null);
            orderDateAo.setDisable(true);
        } else {
            certSection.setDisable(false);
            nameAo.setDisable(false);
            desgAo.setDisable(false);
            orderDateAo.setDisable(false);
            orderNumAo.setDisable(false);
        }
        OnChangeCommonUtil.setElementValueByTargetName(certSection.getTarget(), null);
        OnChangeCommonUtil.setElementValueByTargetName(nameAo.getTarget(), null);
        OnChangeCommonUtil.setElementValueByTargetName(desgAo.getTarget(), null);
        OnChangeCommonUtil.setElementValueByTargetName(orderDateAo.getTarget(), null);
        OnChangeCommonUtil.setElementValueByTargetName(orderNumAo.getTarget(), null);
    }

    public static void onChangeStatus(ValidationAware field) {
        ValidationAware resStatus = ValidationUtil.ALL_FIELDS_MAP.get("form15ca.remitterDetls.resStatus");
        String value = field.getData().toString();
        if (value.equals("1")) {
            resStatus.setTarget("form15ca.commonForm.statusCompany");
        } else if (!value.equals("-1") && !value.equals("1")) {
            resStatus.setTarget("form15ca.commonForm.statusRes");
        } else {
            resStatus.setTarget("form15ca.commonForm.resStatus");
        }
    }

    public static void onChangeResStatus(ValidationAware field) {
        OnChangeCommonUtil.setElementValueByTargetName("form15ca.remitterDetls.resStatus", field.getData().toString());
    }

    public static void onChangeOfPartType(String partType, boolean onLoadFlag) {
        TabPane tabPane = Form.getForm().getTabPane();
        Form15CA form15ca = (Form15CA)Form.getForm().getEntity();
        if (!onLoadFlag) {
            form15ca.setNullToForm15CA();
        }
        LoggerManager.LOG.info("Indise loadPart " + partType + " onLoadFlag: " + onLoadFlag);
        while (tabPane.getTabs().size() != 2) {
            tabPane.getTabs().remove(2);
            if (!ValidatorInteface.ERRORS_MAP.isEmpty()) {
                RefHolders.msgContainer.getChildren().clear();
                ValidatorInteface.ERRORS_MAP.clear();
            }
            ValidationUtil.ALL_FIELDS_MAP.clear();
            ValidationUtil.ALL_FIELDS_NODE_MAP.clear();
            ValidationUtil.ALL_TVC.clear();
            ValidationUtil.ALL_TVAC.clear();
        }
        if ("PA".equals(partType)) {
            LoggerManager.LOG.info("Loading PART-A");
            OnChangeUtil.loadPart("/com/itd/efiling/offline/form15ca/fxml/Form15ca-PartA-Tab1.fxml", "PART-A");
            OnChangeUtil.loadPart("/com/itd/efiling/offline/form15ca/fxml/Form15ca-PartA-Verification.fxml", "PART A - Verification");
        } else if ("PB".equals(partType)) {
            LoggerManager.LOG.info("Loading PART-B");
            OnChangeUtil.loadPart("/com/itd/efiling/offline/form15ca/fxml/Form15ca-PartB-Tab1.fxml", "PART B - Section A");
            OnChangeUtil.loadPart("/com/itd/efiling/offline/form15ca/fxml/Form15ca-PartB-Tab2.fxml", "PART B - Section B");
            OnChangeUtil.loadPart("/com/itd/efiling/offline/form15ca/fxml/Form15ca-PartB-Verification.fxml", "PART B - Verification");
        } else if ("PC".equals(partType)) {
            LoggerManager.LOG.info("Loading PART-C");
            if (!onLoadFlag) {
                MessageDialog.Answer opt = MessageDialogCtrl.getConfirmationDialog("Upload 15CB XML", "Please upload Form 15CB xml submitted by CA");
                if (opt.equals((Object)MessageDialog.Answer.NO)) {
                    while (tabPane.getTabs().size() != 2) {
                        tabPane.getTabs().remove(2);
                    }
                    form15ca.setPartType("-1");
                    DataTransporter.updateJfxUiOnLoad(Form.getForm());
                    return;
                }
                OnChangeUtil.loadPart("/com/itd/efiling/offline/form15ca/fxml/Form15ca-PartC-Tab1.fxml", "PART C - Section A");
                OnChangeUtil.loadPart("/com/itd/efiling/offline/form15ca/fxml/Form15ca-PartC-Tab2.fxml", "PART C - Section B");
                OnChangeUtil.loadPart("/com/itd/efiling/offline/form15ca/fxml/Form15ca-PartC-Verification.fxml", "PART C - Verification");
                File xmlFile = JfxCommonUtil.openFileDialog(".xml", "Open");
                if (xmlFile != null) {
                    try {
                        Object entity = XmlUtil.unmarshalForm15CB(xmlFile, Configs.getConfigProperty("jaxb.context.package.name"));
                        FORM15CB form15cb = (FORM15CB)entity;
                        if (form15cb != null) {
                            form15ca.setRemittanceDetls(form15cb.getRemittanceDetails());
                            form15ca.setDtaaDetails(form15cb.getDtaaDetails());
                            form15ca.setItActDetails(form15cb.getItActDetails());
                            form15ca.setTdsDetails(form15cb.getTdsDetails());
                            form15ca.setRemitterDetls(form15cb.getRemitterDetails());
                            form15ca.setRemitteeDetls(form15cb.getRemitteeDetls());
                            form15ca.setAcctntDetls(form15cb.getAcctntDetls());
                            if (form15cb.getRemittanceDetails() != null) {
                                if (form15cb.getRemittanceDetails().getCountryRemMadeSecb() != null) {
                                    form15ca.getRemittanceDetls().setCountryRemMadeSecbView(form15cb.getRemittanceDetails().getCountryRemMadeSecb());
                                }
                                if (form15cb.getRemittanceDetails().getCountryRemMadeSecbDesc() != null) {
                                    form15ca.getRemittanceDetls().setCountryRemMadeSecbDescView(form15cb.getRemittanceDetails().getCountryRemMadeSecbDesc());
                                }
                                if (form15cb.getRemittanceDetails().getRevPurCategory() != null) {
                                    OnChangeUtil.rbiPurposeCodeChange(form15cb.getRemittanceDetails().getRevPurCategory(), form15cb.getRemittanceDetails().getRevPurCode());
                                }
                                if (form15cb.getRemittanceDetails().getPropDateRem() != null) {
                                    form15ca.getRemittanceDetls().setPropDateRemView(form15cb.getRemittanceDetails().getPropDateRem());
                                }
                                if (form15cb.getRemittanceDetails().getNameBankCode() != null) {
                                    String bankCode15CA = ComboBoxOptionsCacher.getValue("form15ca.commonForm.bankCode15CB", form15cb.getRemittanceDetails().getNameBankCode());
                                    form15ca.getRemittanceDetls().setNameBankCode(bankCode15CA);
                                }
                            }
                            DataTransporter.updateJfxUiOnLoad(Form.getForm());
                            if (form15cb.getRemitterDetails().getPan().matches("^[A-Za-z]{5}[0-9]{4}[A-Za-z]{1}$")) {
                                form15ca.getRemitterDetls().setPan(form15cb.getRemitterDetails().getPan());
                            }
                            form15ca.getRemitterDetls().setTan(form15cb.getRemitterDetails().getPan());
                            form15ca.getRemitterDetls().setPan(null);
                        }
                        MessageDialogCtrl.displayErrorDialog("Please import a valid Form 15CB XML generated from the latest utility");
                        while (tabPane.getTabs().size() != 2) {
                            tabPane.getTabs().remove(2);
                            form15ca.setPartType("-1");
                            ValidatorInteface.ERRORS_MAP.clear();
                            RefHolders.msgContainer.getChildren().clear();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    MessageDialogCtrl.getConfirmationDialog("Invalid 15CB XML", "Please upload valid Form 15CB xml submitted by CA");
                    while (tabPane.getTabs().size() != 2) {
                        tabPane.getTabs().remove(2);
                        form15ca.setPartType("-1");
                        ValidatorInteface.ERRORS_MAP.clear();
                        RefHolders.msgContainer.getChildren().clear();
                    }
                }
                DataTransporter.updateJfxUiOnLoad(Form.getForm());
            } else {
                OnChangeUtil.loadPart("/com/itd/efiling/offline/form15ca/fxml/Form15ca-PartC-Tab1.fxml", "PART C - Section A");
                OnChangeUtil.loadPart("/com/itd/efiling/offline/form15ca/fxml/Form15ca-PartC-Tab2.fxml", "PART C - Section B");
                OnChangeUtil.loadPart("/com/itd/efiling/offline/form15ca/fxml/Form15ca-PartC-Verification.fxml", "PART C - Verification");
            }
        } else if ("PD".equals(partType)) {
            LoggerManager.LOG.info("Loading PART-D");
            OnChangeUtil.loadPart("/com/itd/efiling/offline/form15ca/fxml/Form15ca-PartD-Tab1.fxml", "PART D - Section A");
            OnChangeUtil.loadPart("/com/itd/efiling/offline/form15ca/fxml/Form15ca-PartD-Verification.fxml", "PART D - Verification");
            LoggerManager.LOG.info("After Loading PART-B");
        }
        RefHolders.formPlayerController.setFormControls();
        tabPane.getSelectionModel().select(2);
    }

    public static void disableEnableFields(Form15CA f15ca) {
        boolean ifPartC = false;
        if (f15ca.getPartType().equals("PC")) {
            ifPartC = true;
        }
        if (f15ca.getRemittanceDetls() != null) {
            if (f15ca.getRemittanceDetls().getNatureRemCategory() != null && f15ca.getRemittanceDetls().getNatureRemCategory().equals("16.99")) {
                ValidationUtil.ALL_FIELDS_MAP.get("form15ca.remittanceDetls.natureRemCode").setDisable(false);
            }
            if (f15ca.getRemittanceDetls().getNameBankCode() != null && f15ca.getRemittanceDetls().getNameBankCode().equals("999") && !ifPartC) {
                ValidationUtil.ALL_FIELDS_MAP.get("form15ca.remittanceDetls.nameBankDesc").setDisable(false);
            }
            if (f15ca.getRemittanceDetls().getCurrencySecbCode() != null && f15ca.getRemittanceDetls().getCurrencySecbCode().equals("99") && !ifPartC) {
                ValidationUtil.ALL_FIELDS_MAP.get("form15ca.remittanceDetls.currencySecbDesc").setDisable(false);
            }
            if (f15ca.getRemittanceDetls().getCountryRemMadeSecb() != null && f15ca.getRemittanceDetls().getCountryRemMadeSecb().equals("9999") && !f15ca.getPartType().equals("PC")) {
                ValidationUtil.ALL_FIELDS_MAP.get("form15ca.remittanceDetls.countryRemMadeSecbDesc").setDisable(false);
            }
        }
        if (f15ca.getRemitteeDetls() != null && f15ca.getRemitteeDetls().getCountryRemMade() != null && f15ca.getRemitteeDetls().getCountryRemMade().equals("9999")) {
            ValidationUtil.ALL_FIELDS_MAP.get("form15ca.remitteeDetls.countryRemMadeDesc").setDisable(false);
        }
        if (f15ca.getAoOrderDetls() != null && ifPartC && f15ca.getAoOrderDetls().getOrderAoFlg() != null && f15ca.getAoOrderDetls().getOrderAoFlg().equals("Y")) {
            ValidationUtil.ALL_FIELDS_MAP.get("form15ca.aoOrderDetls.certSection").setDisable(false);
            ValidationUtil.ALL_FIELDS_MAP.get("form15ca.aoOrderDetls.nameAo").setDisable(false);
            ValidationUtil.ALL_FIELDS_MAP.get("form15ca.aoOrderDetls.designationAo").setDisable(false);
            ValidationUtil.ALL_FIELDS_MAP.get("form15ca.aoOrderDetls.orderDateAo").setDisable(false);
            ValidationUtil.ALL_FIELDS_MAP.get("form15ca.aoOrderDetls.orderNumAo").setDisable(false);
        }
    }

    public static void onLoadPopulateValues(Form15CA f15ca) {
        OnChangeUtil.onChangeOfPartType(f15ca.getPartType(), true);
        Form15CA form15ca = (Form15CA)Form.getForm().getEntity();
        if (f15ca.getDeclaration() != null) {
            String salutation = null;
            if (f15ca.getDeclaration().getIWe().equals("1")) {
                salutation = "I";
            } else if (f15ca.getDeclaration().getIWe().equals("2")) {
                salutation = "We";
            }
            form15ca.getDeclaration().setIWe1(salutation);
            form15ca.getDeclaration().setIWe2(salutation);
            if (salutation.equals("I")) {
                form15ca.getDeclaration().setIWe3("my");
            } else {
                form15ca.getDeclaration().setIWe3("our");
            }
            form15ca.getDeclaration().setIWe4(salutation);
            form15ca.getDeclaration().setIWe5(salutation);
            form15ca.getDeclaration().setIWe6(salutation);
            form15ca.getDeclaration().setStyledName1(f15ca.getDeclaration().getStyledName());
            form15ca.getDeclaration().setVerDesignation1(f15ca.getDeclaration().getVerDesignation());
            form15ca.getDeclaration().setStyledName1(f15ca.getDeclaration().getStyledName());
        }
        if (f15ca.getRemittanceDetls() != null) {
            if (f15ca.getRemittanceDetls().getRevPurCategory() != null) {
                OnChangeUtil.rbiPurposeCodeChange(f15ca.getRemittanceDetls().getRevPurCategory(), f15ca.getRemittanceDetls().getRevPurCode());
            }
            if (f15ca.getRemittanceDetls().getCountryRemMadeSecb() != null) {
                form15ca.getRemittanceDetls().setCountryRemMadeSecbView(f15ca.getRemittanceDetls().getCountryRemMadeSecb());
            }
            if (f15ca.getRemittanceDetls().getCountryRemMadeSecbDesc() != null) {
                form15ca.getRemittanceDetls().setCountryRemMadeSecbDescView(f15ca.getRemittanceDetls().getCountryRemMadeSecbDesc());
            }
            if (f15ca.getRemittanceDetls().getPropDateRem() != null) {
                form15ca.getRemittanceDetls().setPropDateRemView(f15ca.getRemittanceDetls().getPropDateRem());
            }
            if (f15ca.getRemittanceDetls().getNameBankCode() != null && f15ca.getRemittanceDetls().getNameBankCode().length() < 3) {
                String bankCode15CA = ComboBoxOptionsCacher.getValue("form15ca.commonForm.bankCode15CB", f15ca.getRemittanceDetls().getNameBankCode());
                form15ca.getRemittanceDetls().setNameBankCode(bankCode15CA);
            }
        }
        if (f15ca.getRemitterDetls() != null) {
            ValidationAware resStatus = ValidationUtil.ALL_FIELDS_MAP.get("form15ca.remitterDetls.resStatus");
            if (f15ca.getRemitterDetls().getStatus() != null) {
                String value = f15ca.getRemitterDetls().getStatus();
                if (value.equals("1")) {
                    resStatus.setTarget("form15ca.commonForm.statusCompany");
                } else if (!value.equals("-1") && !value.equals("1")) {
                    resStatus.setTarget("form15ca.commonForm.statusRes");
                } else {
                    resStatus.setTarget("form15ca.commonForm.resStatus");
                }
                OnChangeCommonUtil.setElementValueByTargetName(resStatus.getTarget(), f15ca.getRemitterDetls().getResStatus());
                OnChangeCommonUtil.setElementValueByTargetName("form15ca.remitterDetls.resStatus", f15ca.getRemitterDetls().getResStatus());
            }
        }
    }
}

