/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.validation.validators;

import com.itd.efiling.offline.common.config.ErrorMessages;
import com.itd.efiling.offline.common.dialog.MessageDialogBuilder;
import com.itd.efiling.offline.common.exception.CsvImportValidationException;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.reference.holders.RefHolders;
import com.itd.efiling.offline.common.util.JfxCommonUtil;
import com.itd.efiling.offline.javafx.ui.components.TableViewController;
import com.itd.efiling.offline.javafx.ui.components.ValErrorLink;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.TextInputControl;

public abstract class ValidatorInteface {
    public static final String REGEX_INVALID_CHAR = "|(\\s*([\\w\\d_=!@#$%\\^*\\(\\){}\\[\\]\\|\\\\:;',\\.\\?/~`\\-\\+&lt;&gt;&amp;&quot;][\\s\\w\\d_=!@#$%\\^*\\(\\){}\\[\\]\\|\\\\:;',\\.\\?/~`\\-\\+&lt;&gt;&amp;&quot;]*)\\s*)";
    public static final Map<String, ValErrorLink> ERRORS_MAP = new LinkedHashMap<String, ValErrorLink>();
    private String errorCode = null;
    private boolean hasErrors = false;
    private static boolean hasImportErrors = false;
    private boolean errorTabError = true;
    private boolean enablePopupError = true;
    private boolean validateOnCsvImport = false;
    protected boolean validateTableOnSubmit = false;

    public abstract void validate(Object var1, String var2, Node var3);

    public abstract ValidatorInteface getImplementor();

    public void onBlurValidateCtrl(Object val, String name, Node node) {
        this.hasErrors = false;
        node.setStyle("");
        this.errorTabError = true;
        this.enablePopupError = true;
        if (JfxCommonUtil.isFieldInRowEditorPane(node)) {
            this.errorTabError = false;
        }
        ValidatorInteface.clearFieldErrorToValidation(name);
        this.validate(val, name, node);
    }

    public void onCsvImportValidateCtrl(Object val, String name) throws CsvImportValidationException {
        this.validateOnCsvImport = true;
        this.validate(val, name, null);
        this.validateOnCsvImport = false;
    }

    public void onSubmitTableValidateCtrl(Object val, String name, Node node, TableViewController<?> tvc, int index) throws CsvImportValidationException {
        this.hasErrors = false;
        hasImportErrors = false;
        this.validateTableOnSubmit = true;
        try {
            this.validate(val, name, node);
        }
        catch (CsvImportValidationException e) {
            this.hasErrors = true;
            Node tab = JfxCommonUtil.getTab(tvc.getTableView());
            ValErrorLink h = new ValErrorLink(tab, node, "Uma");
            h.wrapTextProperty().setValue(Boolean.valueOf(true));
            h.fire();
            tvc.getTableView().getSelectionModel().select(index - 1);
            String errorMsg = "At Row Number : " + index + " : " + e.getErrorMessage();
            this.popupError(name, errorMsg, node);
        }
        this.validateTableOnSubmit = false;
    }

    public void onSubmitValidateCtrl(Object val, String name, Node node) {
        this.hasErrors = false;
        hasImportErrors = false;
        node.setStyle("");
        this.errorTabError = true;
        this.enablePopupError = false;
        ValidatorInteface.clearFieldErrorToValidation(name);
        if (!JfxCommonUtil.isFieldInRowEditorPane(node)) {
            this.validate(val, name, node);
        }
    }

    public void onSaveValidateCtrl(Object val, String name, Node node) {
        this.hasErrors = false;
        hasImportErrors = false;
        node.setStyle("");
        this.errorTabError = false;
        this.enablePopupError = true;
        ValidatorInteface.clearFieldErrorToValidation(name);
        this.validate(val, name, node);
    }

    public void addTableError(String name, Node node) {
        this.hasErrors = true;
        String errorMsg = ErrorMessages.getError(this.errorCode);
        LoggerManager.LOG.info("errorMsg  : " + errorMsg);
        this.popupError(name, errorMsg, node);
        this.addFieldErrorToValidation(name, errorMsg, node);
    }

    public void addErrorForCsv(String name) {
        String errorMsg = ErrorMessages.getError(this.errorCode);
        throw new CsvImportValidationException(name, errorMsg);
    }

    private void addTableErrorValidateOnSubmit(String name) {
        String errorMsg = ErrorMessages.getError(this.errorCode);
        hasImportErrors = true;
        throw new CsvImportValidationException(name, errorMsg);
    }

    public void addFieldError(String name, Node node) {
        if (this.validateOnCsvImport) {
            this.addErrorForCsv(name);
            return;
        }
        if (this.validateTableOnSubmit) {
            this.addTableErrorValidateOnSubmit(name);
            return;
        }
        this.hasErrors = true;
        node.setStyle("-fx-background-color:#ffcccc;-fx-border-color:gray;-fx-border-radius: 2 2 2 2;");
        if (node instanceof TextInputControl) {
            ((TextInputControl)node).clear();
        }
        String errorMsg = ErrorMessages.getError(this.errorCode);
        LoggerManager.LOG.info("errorMsg  : " + errorMsg);
        if (this.enablePopupError) {
            this.popupError(name, errorMsg, node);
        }
        if (this.errorTabError) {
            this.addFieldErrorToValidation(name, errorMsg, node);
        }
        if (JfxCommonUtil.isFieldInRowEditorPane(node)) {
            LoggerManager.LOG.info("ensureVisible " + node);
            JfxCommonUtil.ensureVisible(node);
        }
    }

    private void popupError(String name, String errorMsg, Node node) {
        MessageDialogBuilder mb = MessageDialogBuilder.error();
        mb.message(errorMsg);
        mb.show(node.getScene().getWindow());
    }

    private void addFieldErrorToValidation(String name, String errorMsg, Node node) {
        if (!ERRORS_MAP.containsKey(name)) {
            Node tab = JfxCommonUtil.getTab(node);
            ValErrorLink h = new ValErrorLink(tab, node, errorMsg);
            h.wrapTextProperty().setValue(Boolean.valueOf(true));
            RefHolders.msgContainer.getChildren().add((Object)h);
            ERRORS_MAP.put(name, h);
        }
    }

    public static void clearFieldErrorToValidation(String name) {
        if (ERRORS_MAP.containsKey(name)) {
            ValErrorLink h = ERRORS_MAP.get(name);
            h.wrapTextProperty().setValue(Boolean.valueOf(true));
            RefHolders.msgContainer.getChildren().remove((Object)h);
            ERRORS_MAP.remove(name);
        }
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public void setHasErrors(boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    public static void focusFirstError() {
        Iterator<String> iterator = ERRORS_MAP.keySet().iterator();
        if (iterator.hasNext()) {
            String string = iterator.next();
            ValErrorLink errorLink = ERRORS_MAP.get(string);
            errorLink.wrapTextProperty().setValue(Boolean.valueOf(true));
            errorLink.fire();
            return;
        }
    }

    public static boolean isValidationSuccess() {
        return ERRORS_MAP.isEmpty();
    }

    public static boolean hasImportErrors() {
        return hasImportErrors;
    }

    public static void setHasImportErrors(boolean hasImportErrors) {
        ValidatorInteface.hasImportErrors = hasImportErrors;
    }
}

