/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.validation.validators;

import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.onchange.util.OnChangeCommonUtil;
import com.itd.efiling.offline.common.player.ctrl.Form;
import com.itd.efiling.offline.common.util.CommonUtil;
import com.itd.efiling.offline.common.util.DataTransporter;
import com.itd.efiling.offline.common.validation.cachers.FieldValidtionCacher;
import com.itd.efiling.offline.common.validation.jaxb.beans.FieldValidatorRoot;
import com.itd.efiling.offline.common.validation.validators.ListUniqueValidator;
import com.itd.efiling.offline.common.validation.validators.ValidatorInteface;
import com.itd.efiling.offline.javafx.ui.components.TableViewAddController;
import com.itd.efiling.offline.javafx.ui.components.TableViewController;
import com.itd.efiling.offline.javafx.ui.components.ValRowEditorPane;
import com.itd.efiling.offline.javafx.ui.components.ValTableView;
import com.itd.efiling.offline.javafx.ui.components.ValidationAware;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.scene.Node;

public class ValidationUtil {
    public static final Map<String, TableViewController<?>> ALL_TVC = new LinkedHashMap();
    public static final Map<String, TableViewAddController<?, ?>> ALL_TVAC = new LinkedHashMap();
    public static final Map<String, ValidationAware> ALL_FIELDS_MAP = new LinkedHashMap<String, ValidationAware>();
    public static final Map<String, Node> ALL_FIELDS_NODE_MAP = new LinkedHashMap<String, Node>();

    public static void addFieldForValidation(String key, ValidationAware value) {
        ALL_FIELDS_MAP.put(key, value);
        ALL_FIELDS_NODE_MAP.put(key, (Node)value);
    }

    public static void formValidate() {
        Set<String> set = ALL_FIELDS_MAP.keySet();
        block0: for (String target : set) {
            Object data = ALL_FIELDS_MAP.get(target).getData();
            Node node = ALL_FIELDS_NODE_MAP.get(target);
            List<FieldValidatorRoot> fieldValidators = FieldValidtionCacher.getValidationImplementor(target);
            if (fieldValidators == null) continue;
            for (FieldValidatorRoot fvr : fieldValidators) {
                ValidatorInteface validator = fvr.getValidator();
                validator.onSubmitValidateCtrl(data, target, node);
                if (!validator.hasErrors()) continue;
                validator.setHasErrors(false);
                continue block0;
            }
        }
        ValidationUtil.validateTableOnSave();
    }

    public static void validateTableOnSave() {
        Set<String> ketSet = ALL_TVC.keySet();
        for (String key : ketSet) {
            TableViewController<?> tvc = ALL_TVC.get(key);
            ValRowEditorPane<?> vrep = tvc.getRowEditorPane();
            LoggerManager.LOG.info("Form.getForm() : " + (Object)((Object)Form.getForm()) + " :: " + key);
            ObservableList targetList = tvc.getTableView().getItems();
            if (targetList == null) continue;
            int index = 0;
            for (Object object : targetList) {
                ++index;
                for (Node node : vrep.getFields()) {
                    if (!(node instanceof ValidationAware)) continue;
                    String fieldTarget = ((ValidationAware)node).getTarget();
                    DataTransporter.transferDataToBean((Object)Form.getForm(), vrep.getTarget(), object);
                    String relativeTarget = CommonUtil.getRelativeTarget(vrep.getTarget(), fieldTarget);
                    Object data = DataTransporter.getObjectFromPath(object, relativeTarget, false);
                    LoggerManager.LOG.fine("relativeTarget : " + relativeTarget + " data " + data);
                    List<FieldValidatorRoot> fieldValidators = FieldValidtionCacher.getValidationImplementor(fieldTarget);
                    if (fieldValidators == null) continue;
                    for (FieldValidatorRoot fvr : fieldValidators) {
                        ValidatorInteface validator = fvr.getValidator();
                        LoggerManager.LOG.fine("validator :  " + validator);
                        if (!(validator instanceof ListUniqueValidator)) {
                            validator.onSubmitTableValidateCtrl(data, fieldTarget, node, tvc, index);
                        }
                        if (!validator.hasErrors()) continue;
                        validator.setHasErrors(false);
                        return;
                    }
                }
            }
        }
    }

    public static boolean validateBeforeSave(List<Node> nodes) {
        for (Node node : nodes) {
            ValidationAware field;
            List<FieldValidatorRoot> fieldValidators;
            if (!(node instanceof ValidationAware) || (fieldValidators = FieldValidtionCacher.getValidationImplementor((field = (ValidationAware)node).getTarget())) == null) continue;
            for (FieldValidatorRoot fvr : fieldValidators) {
                ValidatorInteface validator = fvr.getValidator();
                LoggerManager.LOG.fine("validator :  " + validator);
                validator.onSaveValidateCtrl(field.getData(), field.getTarget(), node);
                if (!validator.hasErrors()) continue;
                validator.setHasErrors(false);
                return false;
            }
        }
        return true;
    }

    public static void callOnChangeUtilOnSave(List<Node> nodes) {
        for (Node node : nodes) {
            if (!(node instanceof ValidationAware)) continue;
            ValidationAware field = (ValidationAware)node;
            OnChangeCommonUtil.executeOnChangeMethod(field);
        }
    }

    public static boolean validateListOnVrepCtrl(String parentPrefix) {
        Set<String> keySet = ALL_FIELDS_MAP.keySet();
        for (String key : keySet) {
            ValidationAware node = ALL_FIELDS_MAP.get(key);
            if (!(node instanceof ValTableView) || !node.getTarget().startsWith(parentPrefix) || ValidationUtil.validateListOnVrep(key)) continue;
            return false;
        }
        return true;
    }

    public static boolean validateListOnVrep(String target) {
        List<FieldValidatorRoot> fieldValidators = FieldValidtionCacher.getValidationImplementor(target);
        List targetList = (List)DataTransporter.getObjectFromPath((Object)Form.getForm(), target);
        LoggerManager.LOG.info("target : " + target + "   ::  " + targetList + " :: " + ALL_FIELDS_NODE_MAP.get(target));
        if (fieldValidators != null) {
            for (FieldValidatorRoot fvr : fieldValidators) {
                ValidatorInteface validator = fvr.getValidator();
                LoggerManager.LOG.info("validator :  " + validator);
                validator.onSaveValidateCtrl(targetList, target, ALL_FIELDS_NODE_MAP.get(target));
                if (!validator.hasErrors()) continue;
                validator.setHasErrors(false);
                return false;
            }
        }
        return true;
    }

    public static Object nvl(Object input, String defalutValue) {
        if (ValidationUtil.isObjectEmpty(input)) {
            return defalutValue;
        }
        return input;
    }

    public static String nvlToStr(Object input) {
        if (ValidationUtil.isObjectEmpty(input)) {
            return "";
        }
        return input.toString();
    }

    public static boolean isObjectEmpty(Object inputString) {
        if (inputString != null) {
            return inputString.toString().isEmpty();
        }
        return true;
    }

    public static int getLengthOfString(String inputString) {
        if (ValidationUtil.isStringEmpty(inputString)) {
            return 0;
        }
        return inputString.trim().length();
    }

    public static boolean isStringEmpty(String inputString) {
        return ValidationUtil.isObjectEmpty(inputString);
    }

    public static long getNvlLongValue(Object number) {
        if (number == null) {
            return 0L;
        }
        return ((Number)number).longValue();
    }
}

