/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.validation.validators;

import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.validation.validators.ValidatorInteface;
import javafx.scene.Node;

public class StringLengthFieldValidator
extends ValidatorInteface {
    private int maxLength;
    private int minLength;
    private boolean doTrim;

    @Override
    public void validate(Object obj, String name, Node node) {
        String val = (String)obj;
        if (val == null || val.length() <= 0) {
            return;
        }
        if (this.doTrim && (val = val.trim()).length() <= 0) {
            return;
        }
        if (!val.matches("|(\\s*([\\w\\d_=!@#$%\\^*\\(\\){}\\[\\]\\|\\\\:;',\\.\\?/~`\\-\\+&lt;&gt;&amp;&quot;][\\s\\w\\d_=!@#$%\\^*\\(\\){}\\[\\]\\|\\\\:;',\\.\\?/~`\\-\\+&lt;&gt;&amp;&quot;]*)\\s*)")) {
            LoggerManager.LOG.info("invalid Char for val " + val);
            this.setErrorCode("error.invalid.char");
            this.addFieldError(name, node);
        }
        if (this.minLength > -1 && val.length() < this.minLength) {
            LoggerManager.LOG.info("val " + val + " name" + name + " minLength  " + this.minLength);
            this.addFieldError(name, node);
        } else if (this.maxLength > -1 && val.length() > this.maxLength) {
            LoggerManager.LOG.info("val " + val + " name" + name + " maxLength  " + this.maxLength);
            this.addFieldError(name, node);
        }
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public boolean isDoTrim() {
        return this.doTrim;
    }

    public void setDoTrim(boolean doTrim) {
        this.doTrim = doTrim;
    }

    @Override
    public ValidatorInteface getImplementor() {
        return new StringLengthFieldValidator();
    }
}

