/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.validation.validators;

import com.itd.efiling.offline.common.util.DateUtil;
import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import com.itd.efiling.offline.common.validation.validators.ValidatorInteface;
import java.util.Date;
import javafx.scene.Node;

public class DateValidator
extends ValidatorInteface {
    private String dateFormat;
    private String minDate;
    private String maxDate;

    @Override
    public void validate(Object val, String name, Node node) {
        if (val == null) {
            return;
        }
        Date inputDate = null;
        if (val instanceof Date) {
            inputDate = (Date)val;
            if (!this.isDateValid(inputDate).booleanValue()) {
                this.addFieldError(name, node);
                return;
            }
        } else {
            inputDate = DateUtil.toDate(val);
            if (inputDate == null) {
                this.addFieldError(name, node);
                return;
            }
            if (!this.isDateValid(inputDate).booleanValue()) {
                this.addFieldError(name, node);
                return;
            }
        }
    }

    @Override
    public ValidatorInteface getImplementor() {
        return new DateValidator();
    }

    public Boolean isDateValid(Date inputDate) {
        if (!ValidationUtil.isObjectEmpty(inputDate)) {
            Date minInputDate;
            if (!ValidationUtil.isStringEmpty(this.minDate) && !inputDate.after(minInputDate = DateUtil.toDate(this.minDate))) {
                return false;
            }
            if (!ValidationUtil.isStringEmpty(this.maxDate) && !inputDate.before(minInputDate = DateUtil.toDate(this.maxDate))) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getMinDate() {
        return this.minDate;
    }

    public void setMinDate(String minDate) {
        this.minDate = minDate;
    }

    public String getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(String maxDate) {
        this.maxDate = maxDate;
    }
}

