/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.validation.validators;

import com.itd.efiling.offline.common.calendar.ConvertorUtil;
import com.itd.efiling.offline.common.util.DateUtil;
import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import com.itd.efiling.offline.common.validation.validators.ValidatorInteface;
import java.text.SimpleDateFormat;
import java.util.Date;
import javafx.scene.Node;

public class ConditionalDateValidator
extends ValidatorInteface {
    private String dateFormat;
    private String minDate;
    private String maxDate;

    @Override
    public void validate(Object val, String name, Node node) {
        if (val == null) {
            return;
        }
        Date inputDate = null;
        if (val instanceof Date) {
            inputDate = (Date)val;
            if (!ValidationUtil.isStringEmpty(this.minDate) && !ValidationUtil.isStringEmpty(this.maxDate)) {
                try {
                    if (!this.conditionalDateValid(inputDate, name).booleanValue()) {
                        this.addFieldError(name, node);
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (!this.currentDateValid(inputDate).booleanValue()) {
                this.addFieldError(name, node);
                return;
            }
        } else {
            inputDate = DateUtil.toDate(val);
            if (inputDate == null) {
                this.addFieldError(name, node);
                return;
            }
        }
    }

    @Override
    public ValidatorInteface getImplementor() {
        return new ConditionalDateValidator();
    }

    public Boolean currentDateValid(Date inputDate) {
        if (!ValidationUtil.isObjectEmpty(inputDate)) {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            Date minInputDate = DateUtil.toDate(sdf.format(new Date()));
            if (inputDate.compareTo(minInputDate) < 0) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Boolean conditionalDateValid(Date inputDate, String name) throws Exception {
        if (!ValidationUtil.isObjectEmpty(inputDate)) {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            Date minInputDate = null;
            Date maxInputDate = null;
            Date currentDate = DateUtil.toDate(sdf.format(new Date()));
            int curasmtYear = ConvertorUtil.getCurrentAsstYear();
            int nextasstYear = ConvertorUtil.getCurrentAsstYear() + 1;
            int assmtYear = ConvertorUtil.getCurrentAsstYear() + 2;
            String indate = "31/03/" + curasmtYear;
            String nextdate = "31/03/" + nextasstYear;
            String endDate = "31/03/" + assmtYear;
            if (name.equals("form15ca.acctntDetls.certDate")) {
                maxInputDate = currentDate;
                minInputDate = currentDate.compareTo(DateUtil.toDate("31/03/2016")) <= 0 ? DateUtil.toDate("01/04/2014") : DateUtil.toDate("01/04/2015");
            } else if (name.equals("form15ca.remittanceDetls.propDateRem") || name.equals("form15cb.remittanceDetails.propDateRem")) {
                minInputDate = DateUtil.toDate("07/06/2021");
                maxInputDate = currentDate.compareTo(DateUtil.toDate(indate)) <= 0 ? DateUtil.toDate(nextdate) : DateUtil.toDate(endDate);
            } else {
                maxInputDate = DateUtil.toDate(sdf.format(new Date()));
                minInputDate = DateUtil.toDate(this.minDate);
            }
            if (inputDate.compareTo(minInputDate) < 0) {
                return false;
            }
            if (inputDate.compareTo(maxInputDate) > 0) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getMinDate() {
        return this.minDate;
    }

    public void setMinDate(String minDate) {
        this.minDate = minDate;
    }

    public String getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(String maxDate) {
        this.maxDate = maxDate;
    }
}

