/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.validation.validators;

import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.player.ctrl.Form;
import com.itd.efiling.offline.common.util.DataTransporter;
import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import com.itd.efiling.offline.common.validation.validators.ValidatorInteface;
import java.util.HashSet;
import java.util.List;
import javafx.scene.Node;

public class ChildListValidator
extends ValidatorInteface {
    private String parentList;
    private String keyFieldName;
    private String parentKeyFieldName;

    @Override
    public void validate(Object val, String name, Node node) {
        if (ValidationUtil.isObjectEmpty(val)) {
            return;
        }
        List childList = (List)val;
        if (childList == null || childList.isEmpty()) {
            this.addTableError(name, node);
            return;
        }
        List list = (List)DataTransporter.getObjectFromPath((Object)Form.getForm(), this.parentList);
        if (list == null || list.isEmpty()) {
            return;
        }
        LoggerManager.LOG.info("list " + list.size());
        HashSet<Object> keyParentSet = new HashSet<Object>();
        HashSet<Object> keyChildSet = new HashSet<Object>();
        for (Object obj : childList) {
            Object keyVal = DataTransporter.getObjectFromPath(obj, this.keyFieldName);
            keyChildSet.add(keyVal);
        }
        for (Object object : list) {
            Object keyValue = DataTransporter.getObjectFromPath(object, this.parentKeyFieldName);
            keyParentSet.add(keyValue);
        }
        LoggerManager.LOG.info("keyParentSet size is {}" + keyParentSet.size());
        LoggerManager.LOG.info("keyChildSet size is {}" + keyChildSet.size());
        if (keyParentSet.size() != keyChildSet.size()) {
            this.setErrorCode("error.keyParentSet.keyChildSet.mismatch");
            this.addFieldError(name, node);
        }
    }

    @Override
    public ValidatorInteface getImplementor() {
        return new ChildListValidator();
    }

    public String getParentList() {
        return this.parentList;
    }

    public void setParentList(String parentList) {
        this.parentList = parentList;
    }

    public String getKeyFieldName() {
        return this.keyFieldName;
    }

    public void setKeyFieldName(String keyFieldName) {
        this.keyFieldName = keyFieldName;
    }

    public String getParentKeyFieldName() {
        return this.parentKeyFieldName;
    }

    public void setParentKeyFieldName(String parentKeyFieldName) {
        this.parentKeyFieldName = parentKeyFieldName;
    }
}

