/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.validation.cachers;

import com.itd.efiling.offline.common.config.Configs;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.validation.validators.ValidatorInteface;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class ValidationTypeCacher {
    private static final Map<String, ValidatorInteface> VALIDATORS_TYPE_MAP = new LinkedHashMap<String, ValidatorInteface>();

    private ValidationTypeCacher() {
    }

    private static void load() {
        try {
            Properties properties = new Properties();
            InputStream is = ValidationTypeCacher.class.getResourceAsStream(Configs.getConfigProperty("validator.properties"));
            properties.load(is);
            Set<Object> keys = properties.keySet();
            for (Object obj : keys) {
                String key = (String)obj;
                String className = properties.getProperty(key);
                ValidatorInteface validator = (ValidatorInteface)Class.forName(className).newInstance();
                VALIDATORS_TYPE_MAP.put(key, validator);
            }
            is.close();
            LoggerManager.LOG.info("VALIDATORS_TYPE_MAP " + VALIDATORS_TYPE_MAP.size());
        }
        catch (Exception e) {
            LoggerManager.LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public static ValidatorInteface getValidationImplementor(String key) {
        return VALIDATORS_TYPE_MAP.get(key).getImplementor();
    }

    public static Set<String> getValidationTypes() {
        return VALIDATORS_TYPE_MAP.keySet();
    }

    static {
        ValidationTypeCacher.load();
    }
}

