/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.util;

import com.itd.efiling.offline.common.logging.util.LoggerManager;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Locale;
import java.util.logging.Level;

public class MethodFinder {
    private static String constructAssessorName(String prefix, String field) {
        return prefix + field.substring(0, 1).toUpperCase(Locale.US) + field.substring(1);
    }

    public static MethodHandle getGetter(Object object, String field) {
        String methodName = MethodFinder.constructAssessorName("get", field);
        MethodHandle getter = null;
        try {
            getter = MethodHandles.lookup().findVirtual(object.getClass(), methodName, MethodType.methodType(object.getClass().getMethod(methodName, new Class[0]).getReturnType())).bindTo(object);
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            LoggerManager.LOG.severe("No such getter: " + ex.getLocalizedMessage());
            LoggerManager.LOG.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
        return getter;
    }

    public static MethodHandle getSetter(Object object, String field, MethodHandle getter) {
        String methodName = MethodFinder.constructAssessorName("set", field);
        MethodHandle setter = null;
        try {
            setter = MethodHandles.lookup().findVirtual(object.getClass(), methodName, MethodType.methodType(Void.TYPE, getter.type().returnType())).bindTo(object);
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            LoggerManager.LOG.severe("No such setter: " + ex.getLocalizedMessage());
            LoggerManager.LOG.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
        return setter;
    }
}

