/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.util;

import com.itd.efiling.offline.common.config.Configs;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.player.ctrl.Form;
import com.itd.efiling.offline.common.reference.holders.RefHolders;
import com.itd.efiling.offline.javafx.ui.components.ValRowEditorPane;
import com.itd.efiling.offline.javafx.ui.components.ValTextArea;
import com.itd.efiling.offline.javafx.ui.components.ValTextField;
import com.itd.efiling.offline.javafx.ui.components.ValidationAware;
import java.io.File;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TitledPane;
import javafx.stage.FileChooser;
import javafx.stage.Window;

public class JfxCommonUtil {
    private static File initDirectory = null;

    public static File openFileDialog(String extension, String title) {
        return JfxCommonUtil.fileDialog(extension, title, false);
    }

    public static File saveFileDialog(String extension, String title) {
        return JfxCommonUtil.fileDialog(extension, title, true);
    }

    private static File fileDialog(String extension, String title, boolean saveFlag) {
        String[] ext;
        LoggerManager.LOG.info("extension : " + extension + " title : " + title);
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = null;
        for (String exten : ext = extension.split(",")) {
            if (exten.toUpperCase().indexOf("DRAFT") != -1) {
                extFilter = new FileChooser.ExtensionFilter("DRAFT File (" + exten + ")", new String[]{"*" + exten});
            } else if (exten.toUpperCase().indexOf("PFX") != -1 || exten.toUpperCase().indexOf("P12") != -1) {
                extFilter = new FileChooser.ExtensionFilter(".PFX/.P12 File (" + exten + ")", new String[]{"*" + exten});
            } else if (exten.toUpperCase().indexOf("ZIP") != -1) {
                extFilter = new FileChooser.ExtensionFilter("ZIP File (" + exten + ")", new String[]{"*" + exten});
            } else if (exten.toUpperCase().indexOf("PDF") != -1) {
                extFilter = new FileChooser.ExtensionFilter("PDF File (" + exten + ")", new String[]{"*" + exten});
            } else if (exten.toUpperCase().indexOf("EXE") != -1) {
                extFilter = new FileChooser.ExtensionFilter("EXE File (" + exten + ")", new String[]{"*" + exten});
            } else if (exten.toUpperCase().indexOf("CSV") != -1) {
                extFilter = new FileChooser.ExtensionFilter("CSV File (" + exten + ")", new String[]{"*" + exten});
            } else if (exten.toUpperCase().indexOf("XML") != -1) {
                extFilter = new FileChooser.ExtensionFilter("XML File (*.xml)", new String[]{"*.xml"});
            } else if (exten.toUpperCase().indexOf("OPEN") != -1) {
                extFilter = ".zip".equals(Configs.getConfigProperty("final.save.file.type")) ? new FileChooser.ExtensionFilter("File (*.zip,*.draft)", new String[]{"*.zip", "*.draft"}) : new FileChooser.ExtensionFilter("XML File (*.xml,*.draft)", new String[]{"*.xml", "*.draft"});
            } else if (exten.toUpperCase().indexOf("DSC") != -1) {
                extFilter = new FileChooser.ExtensionFilter("DSC File (" + exten + ")", new String[]{"*" + exten});
            } else if (exten.toUpperCase().indexOf("XLSX") != -1) {
                extFilter = new FileChooser.ExtensionFilter("EXCEL File (" + exten + ")", new String[]{"*" + exten});
            }
            fileChooser.getExtensionFilters().add((Object)extFilter);
        }
        fileChooser.setInitialDirectory(initDirectory);
        if (title != null) {
            fileChooser.setTitle(title);
        }
        File tempFile = null;
        if (saveFlag) {
            String file;
            tempFile = fileChooser.showSaveDialog((Window)RefHolders.stage);
            if (tempFile != null && !(file = tempFile.getAbsolutePath()).toUpperCase().endsWith(extension.toUpperCase())) {
                tempFile = new File(file + extension);
            }
        } else {
            tempFile = fileChooser.showOpenDialog(null);
        }
        if (tempFile != null && tempFile.getParentFile().isDirectory()) {
            initDirectory = tempFile.getParentFile();
        }
        return tempFile;
    }

    public static void setFieldStatus(ValidationAware control) {
        ValTextArea txt;
        if (control instanceof ValTextField) {
            ValTextField txt2 = (ValTextField)control;
            if (txt2.isEditable() && txt2.isFocused()) {
                JfxCommonUtil.setFieldStatus(txt2.getMaxLength(), txt2.getMaxLength() - (txt2.getText() == null ? 0 : txt2.getText().length()));
            }
        } else if (control instanceof ValTextArea && (txt = (ValTextArea)control).isEditable() && txt.isFocused()) {
            JfxCommonUtil.setFieldStatus(txt.getMaxLength(), txt.getMaxLength() - (txt.getText() == null ? 0 : txt.getText().length()));
        }
    }

    public static void setText(ValidationAware control, String text) {
        ValTextArea txt;
        if (control instanceof ValTextField) {
            ValTextField txt2 = (ValTextField)control;
            txt2.setText(text);
        } else if (control instanceof ValTextArea && (txt = (ValTextArea)control).isEditable() && txt.isFocused()) {
            JfxCommonUtil.setFieldStatus(txt.getMaxLength(), txt.getMaxLength() - (txt.getText() == null ? 0 : txt.getText().length()));
        }
    }

    public static void setFieldStatus(int max, int rem) {
        Form frm = Form.getForm();
        if (frm != null) {
            if (max == 0 && rem == 0) {
                frm.setStatus("");
                return;
            }
            frm.setStatus(String.format("Max Length: %8d       Remaining: %8d", max, rem));
        }
    }

    public static void clearFieldStatus() {
        Form frm = Form.getForm();
        if (frm != null) {
            frm.setStatus("");
            return;
        }
    }

    public static Node getTab(Node node) {
        Node tab = node;
        while ((tab = tab.getParent()) instanceof Node) {
            if (!"Content".equals(tab.getId())) continue;
            return tab;
        }
        return null;
    }

    public static Node navigateToTab(Node node) {
        Node nodeTab = JfxCommonUtil.getTab(node);
        ObservableList tabs = Form.getForm().getTabPane().getTabs();
        for (Tab tab : tabs) {
            if (!tab.getContent().equals(nodeTab) || tab.isSelected()) continue;
            Form.getForm().getTabPane().getSelectionModel().select((Object)tab);
            tab.getContent().visibleProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                    ov.removeListener((ChangeListener)this);
                }
            });
        }
        return null;
    }

    public static boolean isFieldInRowEditorPane(Node field) {
        Node node = field;
        while ((node = node.getParent()) instanceof Node) {
            if (node instanceof ValRowEditorPane) {
                LoggerManager.LOG.fine("node : " + node);
                return true;
            }
            if (!(node instanceof TitledPane)) continue;
            LoggerManager.LOG.fine("node : " + node);
            return true;
        }
        return false;
    }

    public static void ctrlHome() {
        ScrollPane pane = RefHolders.scrollPane;
        pane.setVvalue(0.0);
        pane.setHvalue(0.0);
    }

    public static void ensureVisible(Node node) {
        ScrollPane pane = RefHolders.scrollPane;
        double height = pane.getContent().getBoundsInLocal().getHeight();
        double y = node.getBoundsInParent().getMaxY();
        pane.setVvalue(y / height);
    }

    public static void clearVrepFieldErrors(ValRowEditorPane<?> vrep) {
        for (Node node : vrep.getFields()) {
            if (!(node instanceof ValidationAware)) continue;
            node.setStyle("");
        }
    }
}

