/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.util;

import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtil {
    public static boolean isDateValid(String inputDate, String dateFormat) {
        boolean isDateValid = false;
        try {
            if (ValidationUtil.isStringEmpty(inputDate)) {
                isDateValid = true;
            } else if (inputDate.length() != 10) {
                isDateValid = false;
            } else {
                Calendar calendar = Calendar.getInstance();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat, Locale.US);
                calendar.setTime(simpleDateFormat.parse(inputDate));
                String actualDate = simpleDateFormat.format(calendar.getTime());
                if (inputDate.trim().equals(actualDate.trim())) {
                    isDateValid = true;
                }
            }
        }
        catch (ParseException parseException) {
            isDateValid = false;
        }
        return isDateValid;
    }

    public static Date toDate(Object value) {
        if (value == null || !DateUtil.isDateValid(value.toString(), "dd/MM/yyyy")) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            sdf.setLenient(false);
            return sdf.parse(value.toString());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String toString(Object value) {
        if (value == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        sdf.setLenient(false);
        return sdf.format(value);
    }

    public static Date toXmlDate(Date value) {
        return DateUtil.xmlStrToDate(DateUtil.dateToXmlString(value));
    }

    public static Date xmlStrToDate(Object value) {
        if (value == null) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            sdf.setLenient(false);
            return sdf.parse(value.toString());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String dateToXmlString(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setLenient(false);
        return sdf.format(date);
    }

    public static String toStringDate_preview(String value) {
        if (value == null) {
            return null;
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
            Date date = formatter.parse(value);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            String formatedDate = cal.get(5) + "/" + (cal.get(2) + 1) + "/" + cal.get(1);
            return formatedDate;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }
}

