/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.util;

import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.player.ctrl.Form;
import com.itd.efiling.offline.common.util.MethodFinder;
import com.itd.efiling.offline.common.validation.validators.ValidationUtil;
import com.itd.efiling.offline.javafx.ui.components.TableInsideTable;
import com.itd.efiling.offline.javafx.ui.components.TableViewAddController;
import com.itd.efiling.offline.javafx.ui.components.TableViewController;
import com.itd.efiling.offline.javafx.ui.components.ValComboBox;
import com.itd.efiling.offline.javafx.ui.components.ValTableView;
import com.itd.efiling.offline.javafx.ui.components.ValidationAware;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import javafx.scene.Node;

public class DataTransporter {
    public static void updateJfxUiOnLoad(Form src) {
        Set<String> keySet = ValidationUtil.ALL_FIELDS_MAP.keySet();
        for (String key : keySet) {
            ValidationAware field = ValidationUtil.ALL_FIELDS_MAP.get(key);
            if (field instanceof ValTableView || field.getTarget().indexOf(".type.") != -1) continue;
            Object dataToSet = DataTransporter.getObjectFromPath((Object)src, field.getTarget(), false);
            if (field instanceof ValComboBox) {
                dataToSet = ValidationUtil.nvl(dataToSet, "-1");
            }
            LoggerManager.LOG.fine("dataToSet : " + dataToSet + " : " + field.getTarget());
            field.setData(dataToSet);
        }
        DataTransporter.updateTableView(src);
        DataTransporter.updateTableViewAddCtrl(src);
    }

    public static void updateTableView(Form src) {
        try {
            Set<String> keySet = ValidationUtil.ALL_TVC.keySet();
            for (String key : keySet) {
                TableViewController<?> tvc = ValidationUtil.ALL_TVC.get(key);
                if (tvc instanceof TableInsideTable) {
                    TableInsideTable tit = (TableInsideTable)((Object)tvc);
                    LoggerManager.LOG.info("Before tit init : " + tit + " key " + key);
                    tit.initOnLoadRecrusively(src);
                    continue;
                }
                LoggerManager.LOG.info("Before tvc init : " + tvc + " key " + key);
                tvc.initOnLoad(src);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void updateTableViewAddCtrl(Form src) {
        try {
            Set<String> keySet = ValidationUtil.ALL_TVAC.keySet();
            for (String key : keySet) {
                TableViewAddController<?, ?> tvac = ValidationUtil.ALL_TVAC.get(key);
                LoggerManager.LOG.info("Before tvac init : " + tvac + " key " + key);
                tvac.initOnLoadRecrusively(src);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void updateTableView_(Form src) {
        Field[] destFields;
        for (Field field : destFields = ((Object)((Object)src)).getClass().getDeclaredFields()) {
            try {
                MethodHandle mh = MethodFinder.getGetter((Object)src, field.getName());
                Object control = mh.invoke();
                if (control == null || !(control instanceof TableViewController)) continue;
                if (control instanceof TableInsideTable) {
                    TableInsideTable tit = (TableInsideTable)control;
                    LoggerManager.LOG.info("Before tit init : " + tit);
                    tit.initOnLoadRecrusively(src);
                    continue;
                }
                TableViewController tvc = (TableViewController)control;
                LoggerManager.LOG.info("Before tvc init : " + tvc);
                tvc.initOnLoad(src);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static Object getObjectFromPath(Object root, String path) {
        return DataTransporter.getObjectFromPath(root, path, true);
    }

    public static Object getObjectFromPath(Object root, String path, boolean createIfNull) {
        try {
            String[] objs = path.split("[.]");
            MethodHandle nxtGetter = MethodFinder.getGetter(root, objs[0]);
            Object nxtRoot = nxtGetter.invoke();
            if (nxtRoot == null) {
                if (createIfNull) {
                    nxtRoot = ((Class)nxtGetter.type().returnType()).newInstance();
                    MethodHandle nxtSetter = MethodFinder.getSetter(root, objs[0], nxtGetter);
                    nxtSetter.invoke(nxtRoot);
                } else {
                    return nxtRoot;
                }
            }
            if (objs.length > 1) {
                return DataTransporter.getObjectFromPath(nxtRoot, path.substring(path.indexOf(".") + 1), createIfNull);
            }
            return nxtRoot;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void transferDataToBean(Object root, String path, Object data) {
        DataTransporter.transferDataToBean(root, path, data, true);
    }

    public static void transferDataToBean(Object root, String path, Object data, boolean formFlag) {
        String[] objPath = path.split("[.]");
        try {
            MethodHandle destGetter = MethodFinder.getGetter(root, objPath[0]);
            MethodHandle destSetter = MethodFinder.getSetter(root, objPath[0], destGetter);
            if (objPath.length > 1) {
                Object dest = destGetter.invoke();
                if (dest == null) {
                    dest = ((Class)destGetter.type().returnType()).newInstance();
                    destSetter.invoke(dest);
                }
                DataTransporter.transferDataToBean(dest, path.substring(path.indexOf(".") + 1), data);
            } else {
                destSetter.invoke(data);
                if (formFlag) {
                    Form.getForm().setChanged(true);
                }
            }
        }
        catch (Throwable ex) {
            LoggerManager.LOG.info("Error While transferDataToBean for path ... " + path);
            LoggerManager.LOG.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }

    public static void transferDataToUI(Object root, String path, Node control) {
        if (!(control instanceof ValidationAware)) {
            return;
        }
        String[] objPath = path.split("[.]");
        try {
            MethodHandle srcGetter = MethodFinder.getGetter(root, objPath[0]);
            Object src = srcGetter.invoke();
            if (src == null) {
                ((ValidationAware)control).setData(src);
                return;
            }
            if (objPath.length > 1) {
                DataTransporter.transferDataToUI(src, path.substring(path.indexOf(".") + 1), control);
            } else {
                ((ValidationAware)control).setData(src);
            }
        }
        catch (Throwable th) {
            LoggerManager.LOG.info("Error While transferDataToUI for path ... " + path);
            LoggerManager.LOG.log(Level.SEVERE, th.getLocalizedMessage(), th);
        }
    }

    public static void shallowCopyBean_(Object src, Object dest) {
        if (src != null && dest != null) {
            Field[] fields;
            for (Field f : fields = src.getClass().getDeclaredFields()) {
                try {
                    MethodHandle gmh = MethodFinder.getGetter(src, f.getName());
                    Object data = gmh.invoke();
                    MethodHandle smh = MethodFinder.getSetter(dest, f.getName(), gmh);
                    smh.invoke(data);
                }
                catch (Throwable ex) {
                    System.err.println(ex.getMessage());
                }
            }
        }
    }

    public static void completeCopyBean(Object src, Object dest) {
        if (src != null && dest != null) {
            Field[] fields;
            for (Field f : fields = src.getClass().getDeclaredFields()) {
                try {
                    Object dd;
                    MethodHandle gmh = MethodFinder.getGetter(src, f.getName());
                    Object data = dd = gmh.invoke();
                    if (dd != null && dd.getClass().toString().indexOf("com.itd.") != -1) {
                        data = dd.getClass().newInstance();
                        DataTransporter.completeCopyBean(dd, data);
                    }
                    MethodHandle smh = MethodFinder.getSetter(dest, f.getName(), gmh);
                    smh.invoke(data);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    System.err.println(ex.getMessage());
                }
            }
        }
    }

    public static void completeCopyBeanExcludeList(Object src, Object dest) {
        if (src != null && dest != null) {
            Field[] fields;
            for (Field f : fields = src.getClass().getDeclaredFields()) {
                try {
                    MethodHandle gmh = MethodFinder.getGetter(src, f.getName());
                    Object dd = gmh.invoke();
                    if (dd instanceof Collection) {
                        LoggerManager.LOG.info("f.getName() : " + f.getName() + " ::  is a list");
                        continue;
                    }
                    Object data = dd;
                    if (dd != null && dd.getClass().toString().indexOf("com.itd.") != -1) {
                        data = dd.getClass().newInstance();
                        DataTransporter.completeCopyBeanExcludeList(dd, data);
                    }
                    MethodHandle smh = MethodFinder.getSetter(dest, f.getName(), gmh);
                    smh.invoke(data);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    System.err.println(ex.getMessage());
                }
            }
        }
    }

    public static Object clone(Object src) throws InstantiationException, IllegalAccessException {
        Object cln = src.getClass().newInstance();
        DataTransporter.completeCopyBean(src, cln);
        return cln;
    }

    public static <S> S clone(Object src, Class<S> cloneClass) throws InstantiationException, IllegalAccessException {
        S cln = cloneClass.newInstance();
        DataTransporter.completeCopyBean(src, cln);
        return cln;
    }
}

