/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.util;

import com.itd.efiling.offline.common.logging.util.LoggerManager;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;

public class CustomValidationHandler
implements ValidationEventHandler {
    private String errorMessage;
    private int previousLineNumber = 0;

    public int getPreviousLineNumber() {
        return this.previousLineNumber;
    }

    public void setPreviousLineNumber(int previousLineNumber) {
        this.previousLineNumber = previousLineNumber;
    }

    public final void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public final boolean handleEvent(ValidationEvent event) {
        boolean continueParsing = true;
        int lineNumber = event.getLocator().getLineNumber();
        String message = event.getMessage();
        LoggerManager.LOG.info(lineNumber + " | " + this.previousLineNumber + " | " + continueParsing + " | " + message);
        if (message != null) {
            if (message.indexOf("expected") != -1 || message.indexOf("value constraint") != -1 || message.indexOf("on element") != -1) {
                continueParsing = false;
            }
            if (message.indexOf(":") != -1) {
                message = message.substring(message.indexOf(":") + 1);
            }
            if (this.previousLineNumber != 0 && this.previousLineNumber != lineNumber) {
                return false;
            }
            if (this.previousLineNumber == lineNumber && (message.indexOf("of element") != -1 || message.indexOf("on element") != -1)) {
                continueParsing = false;
            }
        }
        this.errorMessage = message;
        this.previousLineNumber = lineNumber;
        return continueParsing;
    }
}

