/*
 * Decompiled with CFR 0.152.
 */
package com.itd.efiling.offline.common.player.ctrl;

import com.itd.efiling.offline.common.dialog.MessageDialogCtrl;
import com.itd.efiling.offline.common.dialog.ctrl.CommonDialog;
import com.itd.efiling.offline.common.dsc.util.DscConfigUtil;
import com.itd.efiling.offline.common.dsc.util.DscManagementUtil;
import com.itd.efiling.offline.common.dsc.util.GenerateSignatureFileCtrl;
import com.itd.efiling.offline.common.dsc.util.SignerUtil;
import com.itd.efiling.offline.common.dsc.util.UsbTokenUtil;
import com.itd.efiling.offline.common.logging.util.LoggerManager;
import com.itd.efiling.offline.common.player.ctrl.Form;
import com.itd.efiling.offline.common.reference.holders.RefHolders;
import com.itd.efiling.offline.common.util.JfxCommonUtil;
import com.itd.efiling.offline.common.webservice.util.SubmitFormUtil;
import com.itd.efiling.offline.common.webservice.util.WebserviceHelper;
import com.itd.efiling.offline.javafx.ui.components.ValPasswordField;
import com.itd.efiling.offline.javafx.ui.components.ValRadioButton;
import com.itd.efiling.offline.javafx.ui.components.ValTextField;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class SubmitFormController
implements Initializable {
    public static final SimpleDateFormat DD_MM_YY_DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
    protected Stage dialogStage;
    @FXML
    Label formName;
    @FXML
    Label asstYear;
    @FXML
    Label userPan;
    @FXML
    public ValRadioButton pfxtype;
    @FXML
    public ValRadioButton usbToken;
    @FXML
    public ValRadioButton pcitType;
    @FXML
    public ValRadioButton cpcType;
    @FXML
    ComboBox<String> usbCombo;
    @FXML
    Text keyFile;
    @FXML
    Text errorText;
    @FXML
    ProgressBar progress;
    @FXML
    private Button submit;
    @FXML
    HBox usbtokenComboHbox;
    @FXML
    HBox keyFileHbox;
    @FXML
    ValPasswordField passkey;
    @FXML
    ValTextField userID;
    @FXML
    ValTextField dscPan;
    private static SubmitFormController submitcontroller;

    public void initialize(URL location, ResourceBundle resources) {
        LoggerManager.LOG.info("tpr initialize");
        this.initUsbTokens();
        this.formName.setText(RefHolders.form.getFormName());
        this.asstYear.setText(RefHolders.form.getAsstYear());
        this.userPan.setText(RefHolders.form.getPan());
        this.userID.setText(RefHolders.form.getPan());
        this.dscPan.setText(RefHolders.form.getVerPan());
        Form.getForm().getFormDtl().setUserID(RefHolders.form.getPan());
        Form.getForm().getFormDtl().setDscPan(RefHolders.form.getVerPan());
    }

    private void initUsbTokens() {
        long startTime = System.currentTimeMillis();
        try {
            this.usbCombo.getItems().addAll(UsbTokenUtil.getKeyStoreAliases());
            this.usbCombo.getSelectionModel().selectFirst();
        }
        catch (Exception e) {
            LoggerManager.LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        long endTime = System.currentTimeMillis();
        LoggerManager.LOG.info("Time taken to initialize usb tokens" + (endTime - startTime));
    }

    public static void openSubmitDialog() {
        if (submitcontroller == null) {
            SubmitFormController.initSubmitDialog();
        }
        Form.getForm().getFormDtl().setUserID(RefHolders.form.getPan());
        LoggerManager.LOG.info("Form.getForm().getFormDtl() {}" + Form.getForm().getFormDtl().getUserID());
        SubmitFormController.submitcontroller.dialogStage.show();
    }

    public static void initSubmitDialog() {
        CommonDialog commonDialog = new CommonDialog(true, "Submit Form", SubmitFormController.class.getResource("/com/itd/efiling/offline/common/dialog/ctrl/SubmitForm.fxml"));
        commonDialog.sizeToScene();
        submitcontroller = (SubmitFormController)commonDialog.getController();
        SubmitFormController.submitcontroller.dialogStage = commonDialog;
        SubmitFormController.submitcontroller.dialogStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent t) {
                submitcontroller = null;
            }
        });
    }

    public boolean validateDSCKey() {
        boolean flag = true;
        try {
            SignerUtil signerUtil = new SignerUtil();
            if (this.usbToken.isSelected()) {
                LoggerManager.LOG.info("usb token selected");
                String alias = (String)this.usbCombo.getValue();
                signerUtil.intCertChainUsbToken(UsbTokenUtil.keyStore, alias);
                signerUtil.initSignature(new FileInputStream(SubmitFormUtil.formFile));
                X509Certificate x509cert = UsbTokenUtil.getX509Certificate(alias);
                GenerateSignatureFileCtrl.PanHashValidation(Form.getForm().getFormDtl().getDscPan(), x509cert);
            } else {
                LoggerManager.LOG.info("pfx file selected");
                signerUtil.signFile(new FileInputStream(SubmitFormUtil.formFile), new FileInputStream(SubmitFormUtil.pfxFile), this.passkey.getText());
                KeyStore keyStore = DscManagementUtil.getKeyStore(SubmitFormUtil.pfxFile, this.passkey.getText());
                X509Certificate senderPublicKey = DscManagementUtil.getSenderX509Cert(keyStore);
                GenerateSignatureFileCtrl.PanHashValidation(Form.getForm().getFormDtl().getDscPan(), senderPublicKey);
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().startsWith("error.")) {
                this.setErrorText(e.getMessage());
            } else {
                this.setErrorText("Please enter valid DSC password.");
            }
            LoggerManager.LOG.log(Level.SEVERE, "validateDSCKey error: ", e);
            flag = false;
        }
        LoggerManager.LOG.info("validateDSCKey ends with flag: " + flag);
        return flag;
    }

    @FXML
    public void newUser() {
        RefHolders.hostServices.showDocument("https://incometaxindiaefiling.gov.in/e-Filing/Registration/RegistrationHome.html");
    }

    @FXML
    public void browse() {
        File pfxFile = JfxCommonUtil.openFileDialog("pfx", "Open");
        if (pfxFile != null) {
            this.keyFile.setText(pfxFile.getName());
            SubmitFormUtil.pfxFile = pfxFile;
        }
    }

    @FXML
    public void showPfxLabel() {
        this.usbtokenComboHbox.setDisable(true);
        this.keyFileHbox.setDisable(false);
        this.passkey.setDisable(false);
        this.passkey.setData(null);
        this.usbCombo.getSelectionModel().selectFirst();
    }

    @FXML
    public void showUsbLabel() {
        this.usbtokenComboHbox.setDisable(false);
        this.usbCombo.getSelectionModel().selectFirst();
        this.keyFileHbox.setDisable(true);
        this.passkey.setDisable(true);
        this.passkey.setData(null);
        this.keyFile.setText("");
    }

    public void setErrorText(String errorCode) {
        String errorMessage = DscConfigUtil.getConfigProperty(errorCode);
        this.errorText.setText(errorMessage);
        MessageDialogCtrl.displayErrorDialog(errorMessage);
    }

    public void setProgress(double prog) {
        this.progress.setProgress(prog);
    }

    @FXML
    public void submit() {
        block7: {
            LoggerManager.LOG.info("details {}" + Form.getForm().getFormDtl().toString());
            if (WebserviceHelper.isConnected()) {
                try {
                    if (!this.validateParam()) {
                        return;
                    }
                    this.errorText.setText("");
                    SubmitFormUtil formUtil = new SubmitFormUtil();
                    SubmitFormUtil.controller = this;
                    SubmitFormUtil.formFile = RefHolders.outputFileSave;
                    if (this.validateDSCKey()) {
                        this.progress.setVisible(true);
                        this.progress.setProgress(-1.0);
                        this.generateSignatureFile();
                        this.submit.setDisable(true);
                        Thread thread = new Thread((Runnable)((Object)formUtil));
                        thread.start();
                    }
                }
                catch (Exception e) {
                    LoggerManager.LOG.log(Level.SEVERE, "submit error ", e);
                    if (e.getMessage() != null && e.getMessage().startsWith("error.")) {
                        this.setErrorText(e.getMessage());
                        break block7;
                    }
                    MessageDialogCtrl.displayErrorDialog("Error in submit,Please click submit again. ");
                }
            } else {
                LoggerManager.LOG.log(Level.SEVERE, "submit error : Failed to connect");
                MessageDialogCtrl.displayErrorDialog("Please check your Internet connectivity ");
            }
        }
    }

    public boolean validateParam() {
        boolean flag = true;
        this.errorText.setText("");
        flag = flag && this.validateUserId();
        flag = flag && this.validatePassword();
        flag = flag && this.validateDob();
        flag = flag && this.validateDscPan();
        flag = flag && this.validateDscType();
        flag = flag && this.validateSubmitToType();
        return flag;
    }

    public boolean validateUserId() {
        String l_userId = Form.getForm().getFormDtl().getUserID();
        if (l_userId == null || l_userId.trim().length() == 0) {
            this.setErrorText("error.userid.required");
            return false;
        }
        if (l_userId.length() < 10) {
            this.setErrorText("error.userid.invalid");
            return false;
        }
        return true;
    }

    public boolean validatePassword() {
        String password = Form.getForm().getFormDtl().getUserPassword();
        if (password == null || password.trim().length() == 0) {
            this.setErrorText("error.password.required");
            return false;
        }
        if (password.trim().length() < 8) {
            this.setErrorText("error.password.invalid");
            return false;
        }
        return true;
    }

    public boolean validateDob() {
        if (Form.getForm().getFormDtl().getDob() == null) {
            this.setErrorText("error.dob.required");
            return false;
        }
        String dob = DD_MM_YY_DATE_FORMAT.format(Form.getForm().getFormDtl().getDob());
        if (dob.trim().length() < 10) {
            this.setErrorText("error.dob.invalid");
            return false;
        }
        try {
            DD_MM_YY_DATE_FORMAT.parse(dob);
        }
        catch (Exception e) {
            this.setErrorText("error.dob.invalid");
            return false;
        }
        return true;
    }

    public boolean validateDscPan() {
        String dscPan = Form.getForm().getFormDtl().getDscPan();
        if (dscPan == null || dscPan.trim().length() == 0) {
            this.setErrorText("error.dscpan.required");
            return false;
        }
        if (dscPan.length() < 10) {
            this.setErrorText("error.dscpan.invalid");
            return false;
        }
        return true;
    }

    public boolean validateDscType() {
        if (this.pfxtype.isSelected()) {
            if (this.keyFile == null || this.keyFile.getText().length() == 0) {
                this.setErrorText("error.pfxfile.required");
                return false;
            }
            if (this.passkey == null || this.passkey.getText() == null || this.passkey.getText().length() == 0) {
                this.setErrorText("error.pfx.password.required");
                return false;
            }
        } else if (this.usbToken.isSelected()) {
            if ("Select Certificate".equals(this.usbCombo.getValue())) {
                this.setErrorText("error.usbtype.dsc.required");
                return false;
            }
        } else {
            this.setErrorText("error.dsctype.required");
            return false;
        }
        return true;
    }

    public boolean validateSubmitToType() {
        if (!this.pcitType.isSelected() && !this.cpcType.isSelected()) {
            this.setErrorText("error.submit.to.required");
            return false;
        }
        return true;
    }

    public Button getSubmit() {
        return this.submit;
    }

    @FXML
    public void cancel() {
        this.dialogStage.hide();
        submitcontroller = null;
    }

    public void generateSignatureFile() throws Exception {
        LoggerManager.LOG.info("GenerateSignatureFile starts");
        String signedXmlOutputFile = null;
        if (this.usbToken.isSelected()) {
            String alias = (String)this.usbCombo.getValue();
            signedXmlOutputFile = GenerateSignatureFileCtrl.usbSignXml(RefHolders.outputFileSave, alias, "");
        } else {
            signedXmlOutputFile = GenerateSignatureFileCtrl.pfxSignXml(RefHolders.outputFileSave, SubmitFormUtil.pfxFile, this.passkey.getText());
        }
        LoggerManager.LOG.info("signedXmlOutputFile : " + signedXmlOutputFile);
        RefHolders.signatureFile = new File(signedXmlOutputFile);
        LoggerManager.LOG.info("generateSignatureFile ends");
    }
}

